#include "Led_Lcd.h"
#include "mbed.h"


LedLcd::LedLcd(uint8_t Col)
{
    Column = Col;
    lcd.Clear(LCD_COLOR_BLACK);
    DrawButton(0,"0");
    DrawButton(1,"1");
    DrawButton(2,"2");
    DrawButton(3,"3"); 
}

 void LedLcd::DrawButton(uint8_t number, char title [])
 {
    lcd.SetFont(&Font24);
    lcd.SetTextColor(LCD_COLOR_GREEN );
    lcd.DrawRect(Column * 80,number * 80,80,80);
    lcd.SetTextColor(LCD_COLOR_BLUE );
    lcd.FillRect(Column * 80 + 1,number * 80 + 1,78,78);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE );
    lcd.DisplayStringAt(Column * 80, number * 80, (uint8_t *)title, LEFT_MODE);
 }
 
  void LedLcd::PressButton(uint8_t number, char title  [])
 {
    lcd.SetTextColor(LCD_COLOR_GREEN );
    lcd.FillRect(Column * 80 + 1,number * 80 + 1,78,78);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE );
    lcd.DisplayStringAt(Column * 80, number * 80, (uint8_t *)title, LEFT_MODE);
     
 }
 
 void LedLcd::On(uint8_t Position)
 {
    if (Position == 0)
    {
        PressButton(0,"0");
        DrawButton(1,"1");
        DrawButton(2,"2");
        DrawButton(3,"3");    
    } 
    else if (Position == 1)
    {
        PressButton(1,"1");
        DrawButton(0,"0");
        DrawButton(2,"2");
        DrawButton(3,"3"); 
   
    }
     else if (Position == 2 )
    {
        PressButton(2,"2");
        DrawButton(0,"0");
        DrawButton(1,"1");
        DrawButton(3,"3"); 
    }
     else if (Position == 3)
    {
        PressButton(3,"3");        
        DrawButton(0,"0");
        DrawButton(2,"2");
        DrawButton(1,"1"); 
    }
    else 
    {
        DrawButton(0,"0");
        DrawButton(1,"1");
        DrawButton(2,"2");
        DrawButton(3,"3"); 
    }
 }
 