#include "mbed.h"
#include "math.h"
float batt=0; 
float curr=0;
//variables y metodos para el display
BusOut segments(p28,p23,p20,p19,p29,p26,p22); //g,f,e,d,c,b,a
BusOut digits(p21,p24,p25,p27); //digitos
int mask_plexing[4] ={0x01,0x02,0x04,0x08};//maskara para el multiplexado de digitos
int mask_numbers[10]={0x01,0xcf,0x92,0x06,0x4c,0x24,0x20,0x0f,0x00,0x0c};//maskara de numeros 0,1,2,3,4,5,6,7,8,9
int currDigit=1;//digito que debe estar encendido
int dgt[4]={0,0,0,0};//separando en digitos
Ticker plex;//timer para el multiplexado

void plexing();//funcion de multiplexado
void format(int n);//funcion para dar formato al numero
//----------------------------------
//variables y metodos sensor RPM
InterruptIn hall(p8);//interrupcion del sensor hall
int rpm=0;//guardar rpms
float vel;
void RPM();//calcular rpms
//----------------------------------
//Botones 1 y 2
Timer reboot;//desactivar botones, rebote
bool active=true;//activados??
BusOut leds(LED1,LED2,LED3,LED4);//bus para los leds
InterruptIn btn1(p7);//interrupcion del boton 1
InterruptIn btn2(p6);//interrupcion del boton 2
int mode=1;//seleccion de modo
int maskMode[4]={1,2,4,8};//maskara para el flasheo de leds

void btn1Pressed() {
    if (reboot.read()>0.1) {
        mode--;
        if (mode<=0)
            mode=1;
        leds=maskMode[mode-1];
        reboot.reset();
        reboot.start();
    }
}

void btn2Pressed() {
    if (reboot.read()>0.1) {
        mode++;
        if (mode>=5)
            mode=4;
        leds=maskMode[mode-1];
        reboot.reset();
        reboot.start();
    }
}
//---------------------------------------
//funciones y variables comunicacion xbee
Ticker flasher;
Serial xBee(p9,p10);
DigitalOut resetXbee(p11);
bool flash=true;
char in;
int maskPits[5]={0x00,0xcf,0x00,0x24,0xff};
void rcv() {
    if (xBee.readable()) {
        in=xBee.getc();
        switch (in) {
            case 'r':
                break;
            case 'p':
                mode=5;
                break;

        }
    }
}

void flashing() {
    if (mode==5) {
        if (flash) {
            dgt[0]=maskPits[0];
            dgt[1]=maskPits[1];
            dgt[2]=maskPits[2];
            dgt[3]=maskPits[3];
            leds=15;
            flash=!flash;
        } else {
            dgt[0]=maskPits[4];
            dgt[1]=maskPits[4];
            dgt[2]=maskPits[4];
            dgt[3]=maskPits[4];
            leds=0;
            flash=!flash;
        }
    }
}
//----------------------------------
Timer t;
Ticker sendData;
AnalogIn bateria(p17);
AnalogIn corriente(p18);

void send();

//funcion principal
int main() {
    t.start();
    reboot.start();
    plex.attach(&plexing,0.0002);
    flasher.attach(&flashing,0.2);

    hall.mode(PullDown);
    hall.fall(&RPM);

    btn1.mode(PullUp);
    btn1.fall(&btn1Pressed);
    btn2.mode(PullUp);
    btn2.fall(&btn2Pressed);
    leds=maskMode[mode-1];

    resetXbee=0;
    xBee.baud(57600);
    xBee.attach(&rcv);
    sendData.attach(&send,0.25);
}

//funciones display

void format(int n) {
    long double base=10;
    if (n>9999)
        n=9999;
    for (int i = 3; i >= 0; i--) {
        dgt[3-i] = int (n /(pow(base,i)));
        n -= dgt[3-i]*(pow(base,i));
    }
}

void plexing() {
    segments= mask_numbers[dgt[currDigit-1]];
    digits=mask_plexing[currDigit-1];
    currDigit++;
    if (currDigit>=5)
        currDigit=1;
}
//funciones rpm
void RPM() {
    float time;
    t.stop();
    time=t.read();
    rpm=int((1/time)*60);
    vel=rpm*(0.1053313185/2);
    if (mode==1) {
        format(rpm);
    }
    if(mode==2){
    format(vel);
    }
    t.reset();
    t.start();
}

void send() {
        batt=bateria;
        curr=corriente;
        xBee.printf("%d;%f;%f;%f;\n",rpm,vel,batt,curr);
}