#include "mbed.h"

Timer t;
Ticker tmrSend;

BusOut leds(LED1,LED2,LED3,LED4);
BusOut motor(p10,p11);
int cw=0x02;
int ccw=0x01;

PwmOut vel(p21);

InterruptIn encA(p5);
DigitalIn encB(p6);

Serial bt(p28,p27);

char in;
int rpm;

void dataIn();
void RPM();
void sendData();

int main() {
    t.start();
    vel=0;
    motor=cw;

    bt.baud(115200);
    bt.attach(&dataIn);

    encA.mode(PullUp);
    encA.fall(&RPM);

    tmrSend.attach(&sendData,1);

    bt.printf("Control de velocidad y sentido de motor CC V1.0\n\n\r");

}

void dataIn() {
    if (bt.readable()) {
        in=bt.getc();
        switch (in) {
            case '1':
                bt.printf("Velocidad 25/100\n\r");
                leds=0x01;
                vel=0.25;
                break;
            case '2':
                bt.printf("Velocidad 50/100\n\r");
                leds=0x03;
                vel=0.5;
                break;
            case '3':
                bt.printf("Velocidad 75/100\n\r");
                leds=0x07;
                vel=0.75;
                break;
            case '4':
                bt.printf("Velocidad 100/100\n\r");
                leds=0x0F;
                vel=1;
                break;
            case 'a':
                bt.printf("Sentido de giro: CW\n\r");
                motor=cw;
                break;
            case 's':
                bt.printf("Sentido de giro: CCW\n\r");
                motor=ccw;
                break;
            case 'd':
                bt.printf("Motor detenido\n\r");
                leds=0x00;
                vel=0;
                rpm=0;
                break;
        }
    }
}

void RPM() {
    float time;
    t.stop();
    time=t.read();
    rpm=(1/(time*90)*60);
    t.reset();
    t.start();
}

void sendData() {
    if (vel==0)
        rpm=0;
    bt.printf("Velocidad actual %d RPM\n\r",rpm);
}

