#include "mbed.h"
#include "Servo.h"

Servo servo(p21);

DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalOut l3(LED3);

DigitalIn posServo(p26);
DigitalOut ready(p27);
DigitalOut figura(p28);
InterruptIn inicio(p29);
InterruptIn foto(p30);

Serial pc(USBTX,USBRX);
char in;

void tomarFoto() {
    pc.putc('f');
    l3=1;
    ready=0;
}

void reset() {
    ready=0;
    figura=0;
    l3=0;
}

void dataIn() {
    if (pc.readable()) {
        in=pc.getc();
        switch (in) {
            case '0':
                figura=0;
                ready=1;
                break;
            case '1':
                figura=1;
                ready=1;
                break;
        }
    }
}

int main() {
    pc.baud(9600);
    pc.attach(&dataIn);
    foto.rise(&tomarFoto);
    inicio.rise(&reset);
    foto.mode(PullDown);
    inicio.mode(PullDown);
    posServo.mode(PullDown);

    while (1) {
        l1=ready;
        l2=figura;
        if (posServo==1) {
            servo=1;
        } else {
            servo=0;
        }
    }
}