/**
@file main.h
@brief Header file containing function prototypes, defines and global variables.
@brief Used for interfacing with the SRF02 sensor and the Nokia 5110 LCD Display
@brief Acknowledgements to Craig A. Evans's N5110 Library.
@brief Acknowledgements to Craig A. Evans's SRF02 Library.
@brief Acknowledgements to Peter Drescher's beep Library.
@brief Acknowledgements to JST 2011'S PowerControl Library.
@bried ELEC2645 Embedded System Project
@author Adre N Chin
@date May 2015
*/

#include "mbed.h"
#include "SRF02.h"
#include "N5110.h"
#include "beep.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

/**
@namespace lcd
@brief GPIO pins output to LCD Display
@brief (Vcc, SCE, RST, DC, MOSI, SCK, Backlight)
*/
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

/**
@namespace sensor
@brief I2C pins to SRF02 sensor
@brief (SDA, SCL)
*/
SRF02 sensor(p28, p27);

/**
@namespace button
@brief AnalogIn for Interrupt
*/
InterruptIn button(p17);

/**
@namespace buzzer
@brief PWMOut to buzzer
*/
Beep buzzer(p21);

/**
@namespace green
@brief PWMOut to green LED
*/
PwmOut green(p22);

/**
@namespace green
@brief PWMOut to yellow LED
*/
PwmOut yellow(p23);

/**
@namespace green
@brief PWMOut to red LED
*/
PwmOut red(p24);


//Main prototypes of the system is stored here
/**
print welcome message
*/
void welcomeMessage();

/**
  * Get the current time and format it into a string
  * @param time - Create buffer for time
  * @param day - Create buffer for day
  * @param date - Create buffer for date
  * @param strftime - Format time into a string
  * @param lcd.printString - print date & time on lcd
  */
void getTime();

/**
  * Tells the sensor to get a distance reading
  * Sensor reading is in cm
  * @param distance - Get distance from sensor
  * @return distance - Store distance as an integer
  */
void getDistance();

/**
  *Use the stored distance to animate the car
  *@param walls() - Hard code walls
  *@param carDistancex() - Set pixel coordinate
  *@param drawCar() - Draw car at previous set coordinate
  */
void readDistance();

/**
  *SAFE distance indicator
  *@param red - Turn red LED off
  *@param yellow - Turn yellow LED off
  *@param green - Turn green LED on
  *@param buzzer - 800hz beep for 0.05 seconds
  */
void distance1();

/**
  *CAUTION distance indicator
  *@param red - Turn red LED off
  *@param yellow - Turn yellow LED on
  *@param green - Turn green LED off
  *@param buzzer - 800hz beep for 0.2 seconds
  */
void distance2();

/**
  *CLOSE distance indicator
  *@param red - Turn red LED on
  *@param yellow - Turn yellow LED off
  *@param green - Turn green LED off
  *@param buzzer - 800hz beep for 0.7 seconds
  */
void distance3();

/**
  *DANGER distance indicator
  *@param red - Turn red LED on
  *@param yellow - Turn yellow LED off
  *@param green - Turn green LED off
  *@param buzzer - 1khz beep for 30 seconds (continuous)
  */
void distanceDanger();

/**
  *Show distance value to the user
  *@param buffer1 - Create buffer for distance
  *@param length - Put distance inside the buffer
  *@param lcd.printString - Print the distance if the amount of character is =< 4
  */
void printDistance();

/**
  *Use the appropriate buzzer interval and LED based on distance
  *@param distance1 - SAFE distance indicator
  *@param distance2 - CAUTION distance indicator
  *@param distance3 - CLOSE distance indicator
  *@param distanceDanger - DANGER distance indicator
  */
void beeperDistance();

//RTC configs
/**
  *Set up button for ISR
  *@param buttonFlag - Button will set flag when button is pressed
  */
void buttonPressed();
int setTimeFlag = 0; /*!<Variable to check flag status*/
int buttonFlag = 0; /*!<Variable to check for interrupts*/

/**
  *Hard Code Object and Zones
  *@param safeWall - First zone
  *@param cautionWall - Second zone
  *@param dangerWall - Third zone
  *@param object - Object
  */
void walls();
void safeWall(); /*!<First Zone*/
void cautionWall(); /*!<Second Zone*/
void dangerWall(); /*!<Third Zone*/
void object(); /*!<Object*/

//Car Animation
/**
  *Set up global variables for pixels
  *The functions below change pixel coordinates via the global variable of each pixels
  *@param a0 - Pixel coordinates for front of car
  *@param a1 - Pixel coordinates for front of car
  *@param a2 - Pixel coordinates for front of car
  *@param b0 - Pixel coordinates for middle of car
  *@param b1 - Pixel coordinates for middle of car
  *@param b2 - Pixel coordinates for middle of car
  *@param b3 - Pixel coordinates for middle of car
  *@param c0 - Pixel coordinates for back of car
  *@param c1 - Pixel coordinates for back of car
  *@param c2 - Pixel coordinates for back of car
  *@param d0 - Pixel coordinates for front of car
  *@param e0 - Pixel coordinates for back of car
  *@param e1 - Pixel coordinates for back of car
  *@param f0 - Pixel coordinates for front of car
  *@param g0 - Pixel coordinates for back of car
  *@param g1 - Pixel coordinates for back of car
  *@param h0 - Pixel coordinates for front of car
  *@param h1 - Pixel coordinates for front of car
  *@param h2 - Pixel coordinates for front of car
  *@param h3 - Pixel coordinates for front of car
  *@param i0 - Pixel coordinates for back of car
  *@param i1 - Pixel coordinates for back of car
  *@param i2 - Pixel coordinates for back of car
  *@param i3 - Pixel coordinates for back of car
  *@param j0 - Pixel coordinates for front of car
  *@param j1 - Pixel coordinates for front of car
  *@param k0 - Pixel coordinates for back of car
  *@param k1 - Pixel coordinates for back of car
  *@param l0 - Pixel coordinates for front of car
  *@param l1 - Pixel coordinates for front of car
  *@param m0 - Pixel coordinates for back of car
  *@param m1 - Pixel coordinates for back of car
  *@param n0 - Pixel coordinates for front of car
  *@param n1 - Pixel coordinates for front of car
  *@param o0 - Pixel coordinates for back of car
  *@param o1 - Pixel coordinates for back of car
  *@param q0 - Pixel coordinates for roof of car
  *@param q1 - Pixel coordinates for roof of car
  *@param q2 - Pixel coordinates for roof of car
  *@param q3 - Pixel coordinates for roof of car
  *@param q4 - Pixel coordinates for roof of car
  *@param q5 - Pixel coordinates for roof of car
  *@param q6 - Pixel coordinates for roof of car
  *@param q7 - Pixel coordinates for roof of car
  *@param w0 - Pixel coordinates for wheel of car
  *@param w1 - Pixel coordinates for wheel of car
  */
void drawCar();
void carDistance1(); /*!<Distance more than 205*/
void carDistance2(); /*!<Distance between 195 to 204*/
void carDistance3(); /*!<Distance between 180 and 194*/
void carDistance4(); /*!<Distance between 165 and 179*/
void carDistance5(); /*!<Distance between 150 and 164*/
void carDistance6(); /*!<Distance between 135 and 149*/
void carDistance7(); /*!<Distance between 120 and 134*/
void carDistance8(); /*!<Distance between 105 and 119*/
void carDistance9(); /*!<Distance between 90 and 104*/
void carDistance10(); /*!<Distance between 75 and 89*/
void carDistance11(); /*!<Distance between 60 and 74*/
void carDistance12(); /*!<Distance between 45 and 59*/
void carDistance13(); /*!<Distance between 30 and 44*/
void carDistance14(); /*!<Distance between 21 and 29*/
void carDistance15(); /*!<Distance below 20*/

//variables
int distance; /*!<Distance of object from the car*/

//Variables for car animation
int a0; /*!<Set pixel coordinates for front of car*/
int a1; /*!<Set pixel coordinates for front of car*/
int a2; /*!<Set pixel coordinates for front of car*/
int b0; /*!<Set pixel coordinates for middle of car*/
int b1; /*!<Set pixel coordinates for middle of car*/
int b2; /*!<Set pixel coordinates for middle of car*/
int b3; /*!<Set pixel coordinates for middle of car*/
int c0; /*!<Set pixel coordinates for back of car*/
int c1; /*!<Set pixel coordinates for back of car*/
int c2; /*!<Set pixel coordinates for back of car*/
int d0; /*!<Set pixel coordinates for front of car*/
int e0; /*!<Set pixel coordinates for back of car*/
int e1; /*!<Set pixel coordinates for back of car*/
int f0; /*!<Set pixel coordinates for front of car*/
int g0; /*!<Set pixel coordinates for back of car*/
int g1; /*!<Set pixel coordinates for back of car*/
int h0; /*!<Set pixel coordinates for front of car*/
int h1; /*!<Set pixel coordinates for front of car*/
int h2; /*!<Set pixel coordinates for front of car*/
int h3; /*!<Set pixel coordinates for front of car*/
int i0; /*!<Set pixel coordinates for back of car*/
int i1; /*!<Set pixel coordinates for back of car*/
int i2; /*!<Set pixel coordinates for back of car*/
int i3; /*!<Set pixel coordinates for back of car*/
int j0; /*!<Set pixel coordinates for front of car*/
int j1; /*!<Set pixel coordinates for front of car*/
int k0; /*!<Set pixel coordinates for back of car*/
int k1; /*!<Set pixel coordinates for back of car*/
int l0; /*!<Set pixel coordinates for front of car*/
int l1; /*!<Set pixel coordinates for front of car*/
int m0; /*!<Set pixel coordinates for back of car*/
int m1; /*!<Set pixel coordinates for back of car*/
int n0; /*!<Set pixel coordinates for front of car*/
int n1; /*!<Set pixel coordinates for front of car*/
int o0; /*!<Set pixel coordinates for back of car*/
int o1; /*!<Set pixel coordinates for back of car*/
int q0; /*!<Set pixel coordinates for roof of car*/
int q1; /*!<Set pixel coordinates for roof of car*/
int q2; /*!<Set pixel coordinates for roof of car*/
int q3; /*!<Set pixel coordinates for roof of car*/
int q4; /*!<Set pixel coordinates for roof of car*/
int q5; /*!<Set pixel coordinates for roof of car*/
int q6; /*!<Set pixel coordinates for roof of car*/
int q7; /*!<Set pixel coordinates for roof of car*/
int w0; /*!<Set pixel coordinates for wheel of car*/
int w1; /*!<Set pixel coordinates for wheel of car*/