/**
@file main.cpp

@brief Program implementation
*/
#include "main.h"

int main() //Main loop
{

    lcd.init(); //LCD display is initiated
    welcomeMessage(); //Printing welcome message
    wait(3); //3 second delay
    lcd.clear(); //Clear the LCD and start main function
    button.rise(&buttonPressed); //creates a rising edge when the button is pressed for an interrupt
    //set_time(1431345864); //This code is commented out to prevent the time from resetting everytime the device is swithed on

    PHY_PowerDown(); //Power down ehternet module of the microcontroller to reduce power consumption

    while (1) {

        if (buttonFlag) { //Check flag status
            setTimeFlag = ~setTimeFlag; //Return TimeFlag to 0 when button is pressed again
            buttonFlag = 0; //Flag is reset
        }
        if (setTimeFlag) { //When mode is change to clock
            lcd.clear(); //Clear LCD to prevent a "stacked display"
            lcd.drawRect(22,30,40,10,0); //Boundary for sensor reading 
            lcd.printChar('c',46,4); //Hard coded "c"
            lcd.printChar('m',53,4); //Harc coded "m"
            getTime(); //Retrieve current time from RTC
            getDistance(); //Read sensor for distance
            beeperDistance(); //Beep based on distance
            printDistance(); //Print distance based on sensor reading
        } else {
            lcd.drawRect(22,30,40,10,0); //Boundary for sensor reading 
            lcd.printChar('c',46,4); //Hard coded "c"
            lcd.printChar('m',53,4); //Hard coded "m"
            getDistance(); //Read sensor for distance
            beeperDistance(); //Beep based on Distance
            printDistance(); //Print distance based on sensor reading
            readDistance(); //Animate the car by moving pixel coordinates
            wait(1); //1 second delay to ensure the beep timing and the reading intervals is the same as in clock mode
            lcd.clear(); //clear the display
        }

    }

}

void welcomeMessage() //Print a welcome message
{
    lcd.printString("Reverse",0,0); //Print "Reverse" at coordinate 0,0
    wait(0.5); //0.5 seconds delay
    lcd.printString("Parking",0,1); //Print "Parking" at coordinate 0,1
    wait(0.5); //0.5 seconds delay
    lcd.printString("Sensor",0,2); //Print "Sensor" at coordinate 0,2
    wait(0.5); //0.5 seconds delay
    lcd.printString("ELEC2645",0,3); //Print "ELEC2645 at coordinate 0,3
    wait(0.5); //0.5 seconds delay
    lcd.printString("200823883",0,4); //Print "200823883" at coordinate 0,4
    wait(0.5); //0.5 seconds delay
    lcd.printString("A N Chin",0,5); //Print "A N Chin at coordinate 0.5
}


void getDistance() //Take reading from the sensor
{
    distance = sensor.getDistanceCm(); //Take reading and input the value into the variable "distance"
}

void readDistance() //Animate the car and show the distance to the user
{
    if (distance >= 205) { //Pixel increment 1
        walls(); //Draw zones and object
        carDistance1(); //Move x pixel to position 1 (Front of car at 1 and back of car at 22)
        drawCar(); //Draw car at pixel
    } else if (distance >= 195 & distance <= 204) { //Pixel increment 2
        walls(); //Draw zones and object
        carDistance2(); //Move x pixel to position 2 (Front of car at 4 and back of car at 25)
        drawCar(); //Draw car at pixel
    } else if (distance >= 180 & distance <= 194) { //Pixel increment 3
        walls(); //Draw zones and object
        carDistance3(); //Move x pixel to position 2 (Front of car at 7 and back of car at 28)
        drawCar(); //Draw car at pixel
    } else if (distance >= 165 & distance <= 179) { //Pixel increment 4
        walls(); //Draw zones and object
        carDistance4(); //Move x pixel to position 2 (Front of car at 10 and back of car at 31)
        drawCar(); //Draw car at pixel
    } else if (distance >= 150 & distance <= 164) { //Pixel increment 5
        walls(); //Draw zones and object
        carDistance5(); //Move x pixel to position 2 (Front of car at 13 and back of car at 34)
        drawCar(); //Draw car at pixel
    } else if (distance >= 135 & distance <= 149) { //Pixel increment 6
        walls(); //Draw zones and object
        carDistance6(); //Move x pixel to position 2 (Front of car at 16 and back of car at 37)
        drawCar(); //Draw car at pixel
    } else if (distance >= 120 & distance <= 134) { //Pixel increment 7
        walls(); //Draw zones and object
        carDistance7(); //Move x pixel to position 2 (Front of car at 19 and back of car at 40)
        drawCar(); //Draw car at pixel
    } else if (distance >= 105 & distance <= 119) { //Pixel increment 8
        walls(); //Draw zones and object
        carDistance8(); //Move x pixel to position 2 (Front of car at 22 and back of car at 43)
        drawCar(); //Draw car at pixel
    } else if (distance >= 90 & distance <= 104) { //Pixel increment 9
        walls(); //Draw zones and object
        carDistance9(); //Move x pixel to position 2 (Front of car at 25 and back of car at 46)
        drawCar(); //Draw car at pixel
    } else if (distance >= 75 & distance <= 89) { //Pixel increment 10
        walls(); //Draw zones and object
        carDistance10(); //Move x pixel to position 2 (Front of car at 28 and back of car at 49)
        drawCar(); //Draw car at pixel
    } else if (distance >= 60 & distance <= 74) { //Pixel increment 11
        walls(); //Draw zones and object
        carDistance11(); //Move x pixel to position 2 (Front of car at 31 and back of car at 52)
        drawCar(); //Draw car at pixel
    } else if (distance >= 45 & distance <= 59) { //Pixel increment 12
        walls(); //Draw zones and object
        carDistance12(); //Move x pixel to position 2 (Front of car at 34 and back of car at 55)
        drawCar(); //Draw car at pixel
    } else if (distance >= 30 & distance <= 44) { //Pixel increment 13
        walls(); //Draw zones and object
        carDistance13(); //Move x pixel to position 2 (Front of car at 37 and back of car at 58)
        drawCar(); //Draw car at pixel
    } else if (distance >= 21 & distance <= 29) { //Pixel increment 14
        walls(); //Draw zones and object
        carDistance14(); //Move x pixel to position 2 (Front of car at 40 and back of car at 61)
        drawCar(); //Draw car at pixel
    } else if (distance <= 20) { //Pixel increment 15
        walls(); //Draw zones and object
        carDistance15(); //Move x pixel to position 2 (Front of car at 43 and back of car at 64)
        drawCar(); //Draw car at pixel
    }
}

void beeperDistance() //Beeper and LED condition
{
    if (distance >= 75) { //Buzzer and LED condition 1
        distance1(); //Green LED and a 0.05 sec beep at 800hz
    } else if (distance >= 45 & distance <= 74) { //Buzzer and LED condition 2
        distance2(); //Yellow LED and a 0.2 sec beep at 800hz
    } else if (distance >= 21 & distance <= 44) { //Buzzer and LED condition 3
        distance3(); //Red LED and a 0.7 sec beep at 800hz
    } else if (distance <= 20) { //Buzzer and LED condition 4
        distanceDanger(); //Red LED and a 30 sec beep at 1khz
    }
}

void printDistance() //Display sensor reading to the user 
{
    char buffer1[4]; //Initiate buffer to print distance
    int length = sprintf(buffer1,"%2d",distance); //Set the buffer to print distance
    if (length <= 4) //If the characters can fit inside the buffer
        lcd.printString(buffer1,27,4); //Print character (distance)
}

void buttonPressed() //ISR for button
{
    buttonFlag = 1; //Set a flag when button is pressed
}

void getTime() //Clock main loop
{

    time_t seconds = time(NULL); // get current time
    char time [30]; //Initiate buffer for "time"
    char day [30]; //Initiate buffer for "day"
    char date [30]; //Initiate buffer for "date"
    strftime(time, 30, "%T", localtime(&seconds)); //Format time as string with ISO8601 time format
    strftime(day, 30, "%A", localtime(&seconds)); //Format day as string with full weekday name
    strftime(date, 30 , "%F", localtime(&seconds)); //Format date as string with Short YYYY-MM-DD date
    lcd.printString (time,18,0); //Print string for time at coordinate 18,0
    lcd.printString (day,26,1); //Print string for day at coordinate 26,1
    lcd.printString (date,13,2); //Print string for date at coordinate 13,2
    wait(1.0); //delay for a second
    lcd.clear(); //clear the LCD
}


void distance1() //Buzzer and LED condition 1
{
    red = 0; //Switch red LED off
    yellow = 0; //Switch yellow LED off
    green = 1; //Switch green LED on
    buzzer.beep(800,0.05); //0.05 sec of buzzer beep at 800hz
}

void distance2() //Buzzer and LED condition 2
{
    red = 0; //Switch red LED off
    yellow = 1; //Switch yellow LED on
    green = 0; //Switch green LED off
    buzzer.beep(800,0.2); //0.2 sec of buzzer beep at 800hz
}

void distance3() //Buzzer and LED condition 3
{
    red = 1; //Switch red LED on
    yellow = 0; //Switch yellow LED off
    green = 0; //Switch green LED off
    buzzer.beep(800,0.7); //0.7 sec of buzzer beep at 800hz
}
void distanceDanger() //Buzzer and LED condition 4
{
    red = 1; //Switch red LED on
    yellow = 0; //Switch yellow LED off
    green = 0; //Switch green LED off
    buzzer.beep(1000,30); //30 sec of buzzer beep at 1khz
}

void drawCar() //This function draws a car graphic for the "reverse camera" mode of the project and draws a car at the set coordinate
{

    lcd.setPixel(a0,15); //set a pixel at coordinate a0,15
    lcd.setPixel(a1,15); //set a pixel at coordinate a1,15
    lcd.setPixel(a2,15); //set a pixel at coordinate a2,15
    lcd.setPixel(b0,15); //set a pixel at coordinate b0,15
    lcd.setPixel(b1,15); //set a pixel at coordinate b1,15
    lcd.setPixel(b2,15); //set a pixel at coordinate b2,15
    lcd.setPixel(b3,15); //set a pixel at coordinate b3,15
    lcd.setPixel(c0,15); //set a pixel at coordinate c0,15
    lcd.setPixel(c1,15); //set a pixel at coordinate c1,15
    lcd.setPixel(c2,15); //set a pixel at coordinate c2,15
    lcd.setPixel(d0,14); //set a pixel at coordinate d0,14
    lcd.setPixel(e0,14); //set a pixel at coordinate e0,14
    lcd.setPixel(e1,14); //set a pixel at coordinate e1,14
    lcd.setPixel(f0,13); //set a pixel at coordinate f0,13
    lcd.setPixel(g0,13); //set a pixel at coordinate g0,13
    lcd.setPixel(g1,13); //set a pixel at coordinate g1,13
    lcd.setPixel(h0,12); //set a pixel at coordinate h0,12
    lcd.setPixel(h1,12); //set a pixel at coordinate h1,12
    lcd.setPixel(h2,12); //set a pixel at coordinate h2,12
    lcd.setPixel(h3,12); //set a pixel at coordinate h3,12
    lcd.setPixel(i0,12); //set a pixel at coordinate i0,12
    lcd.setPixel(i1,12); //set a pixel at coordinate i1,12
    lcd.setPixel(i2,12); //set a pixel at coordinate i2,12
    lcd.setPixel(i3,12); //set a pixel at coordinate i3,12
    lcd.setPixel(j0,11); //set a pixel at coordinate j0,11
    lcd.setPixel(j1,11); //set a pixel at coordinate j1,11
    lcd.setPixel(k0,11); //set a pixel at coordinate k0,11
    lcd.setPixel(k1,11); //set a pixel at coordinate k1,11
    lcd.setPixel(l0,10); //set a pixel at coordinate l0,10
    lcd.setPixel(l1,10); //set a pixel at coordinate l1,10
    lcd.setPixel(m0,10); //set a pixel at coordinate m0,10
    lcd.setPixel(m1,10); //set a pixel at coordinate m1,10
    lcd.setPixel(n0,9); //set a pixel at coordinate n0,9
    lcd.setPixel(n1,9); //set a pixel at coordinate n1,9
    lcd.setPixel(o0,9); //set a pixel at coordinate o0,9
    lcd.setPixel(o1,9); //set a pixel at coordinate o1,9
    lcd.setPixel(q0,8); //set a pixel at coordinate q0,8
    lcd.setPixel(q1,8); //set a pixel at coordinate q1,8
    lcd.setPixel(q2,8); //set a pixel at coordinate q2,8
    lcd.setPixel(q3,8); //set a pixel at coordinate q3,8
    lcd.setPixel(q4,8); //set a pixel at coordinate q4,8
    lcd.setPixel(q5,8); //set a pixel at coordinate q5,8
    lcd.setPixel(q6,8); //set a pixel at coordinate q6,8
    lcd.setPixel(q7,8); //set a pixel at coordinate q7,8
    lcd.drawCircle(w0/2,30/2,2,1); //draw a circle at coordinate w0/2,15 
    lcd.drawCircle(w1/2,30/2,2,1); //draw a circle at coordinate w1/2,15
    lcd.refresh();
}

void safeWall() //Draw Safe Zone
{
    lcd.setPixel(38,4); //set a pixel at coordinate 38,4
    lcd.setPixel(49,4); //set a pixel at coordinate 49,4
    lcd.setPixel(40,4); //set a pixel at coordinate 40,4
    lcd.setPixel(41,4); //set a pixel at coordinate 41,4
    lcd.setPixel(42,4); //set a pixel at coordinate 42,4
    lcd.setPixel(43,4); //set a pixel at coordinate 43,4
    lcd.setPixel(44,4); //set a pixel at coordinate 44,4
    lcd.setPixel(45,4); //set a pixel at coordinate 45,4
    lcd.setPixel(45,5); //set a pixel at coordinate 45,5
    lcd.setPixel(45,6); //set a pixel at coordinate 45,6
    lcd.setPixel(45,7); //set a pixel at coordinate 45,7
    lcd.setPixel(44,8); //set a pixel at coordinate 44,8
    lcd.setPixel(44,9); //set a pixel at coordinate 44,9
    lcd.setPixel(44,10); //set a pixel at coordinate 44,10
    lcd.setPixel(44,11); //set a pixel at coordinate 44,11
    lcd.setPixel(44,12); //set a pixel at coordinate 44,12
    lcd.setPixel(43,13); //set a pixel at coordinate 43,13
    lcd.setPixel(43,14); //set a pixel at coordinate 43,14
    lcd.setPixel(43,15); //set a pixel at coordinate 43,15
    lcd.setPixel(43,16); //set a pixel at coordinate 43,16
    lcd.setPixel(43,17); //set a pixel at coordinate 43,17
    lcd.setPixel(42,18); //set a pixel at coordinate 42,18
    lcd.setPixel(42,19); //set a pixel at coordinate 42,19
    lcd.setPixel(42,20); //set a pixel at coordinate 42,20
    lcd.setPixel(42,21); //set a pixel at coordinate 42,21
    lcd.setPixel(41,21); //set a pixel at coordinate 41,21
    lcd.setPixel(40,21); //set a pixel at coordinate 40,21
    lcd.setPixel(39,21); //set a pixel at coordinate 39,21
    lcd.setPixel(38,21); //set a pixel at coordinate 38,21
    lcd.setPixel(37,21); //set a pixel at coordinate 37,21
    lcd.setPixel(36,21); //set a pixel at coordinate 36,21
    lcd.setPixel(35,21); //set a pixel at coordinate 35,21
    lcd.refresh(); //refresh the LCD to show the car
}

void cautionWall() //Draw Caution Zone
{
    lcd.setPixel(48,4); //set a pixel at coordinate 48,4
    lcd.setPixel(49,4); //set a pixel at coordinate 49,4
    lcd.setPixel(50,4); //set a pixel at coordinate 50,4 
    lcd.setPixel(51,4); //set a pixel at coordinate 51,4
    lcd.setPixel(52,4); //set a pixel at coordinate 52,4
    lcd.setPixel(53,4); //set a pixel at coordinate 53,4
    lcd.setPixel(54,4); //set a pixel at coordinate 54,4
    lcd.setPixel(55,4); //set a pixel at coordinate 55,4
    lcd.setPixel(55,5); //set a pixel at coordinate 55,5
    lcd.setPixel(55,6); //set a pixel at coordinate 55,6
    lcd.setPixel(55,7); //set a pixel at coordinate 55,7
    lcd.setPixel(54,8); //set a pixel at coordinate 54,8
    lcd.setPixel(54,9); //set a pixel at coordinate 54,9
    lcd.setPixel(54,10); //set a pixel at coordinate 54,10
    lcd.setPixel(54,11); //set a pixel at coordinate 54,11
    lcd.setPixel(54,12); //set a pixel at coordinate 54,12
    lcd.setPixel(53,13); //set a pixel at coordinate 53,13
    lcd.setPixel(53,14); //set a pixel at coordinate 53,14
    lcd.setPixel(53,15); //set a pixel at coordinate 53,15
    lcd.setPixel(53,16); //set a pixel at coordinate 53,16
    lcd.setPixel(53,17); //set a pixel at coordinate 53,17
    lcd.setPixel(52,18); //set a pixel at coordinate 53,18
    lcd.setPixel(52,19); //set a pixel at coordinate 52,19
    lcd.setPixel(52,20); //set a pixel at coordinate 52,20
    lcd.setPixel(52,21); //set a pixel at coordinate 52,21
    lcd.setPixel(51,21);// //set a pixel at coordinate 51,21
    lcd.setPixel(50,21); //set a pixel at coordinate 50,21
    lcd.setPixel(49,21); //set a pixel at coordinate 49,21
    lcd.setPixel(48,21); //set a pixel at coordinate 48,21
    lcd.setPixel(47,21); //set a pixel at coordinate 47,21
    lcd.setPixel(46,21); //set a pixel at coordinate 46,21
    lcd.setPixel(45,21); //set a pixel at coordinate 45,21
    lcd.refresh(); //Refresh LCD display
}

void dangerWall() //Draw Danger Zone
{
    lcd.setPixel(58,4); //set a pixel at coordinate 58,4
    lcd.setPixel(59,4); //set a pixel at coordinate 59,4
    lcd.setPixel(60,4); //set a pixel at coordinate 60,4
    lcd.setPixel(61,4); //set a pixel at coordinate 61,4
    lcd.setPixel(62,4); //set a pixel at coordinate 62,4
    lcd.setPixel(63,4); //set a pixel at coordinate 63,4
    lcd.setPixel(64,4); //set a pixel at coordinate 64,4
    lcd.setPixel(65,4); //set a pixel at coordinate 65,4
    lcd.setPixel(65,5); //set a pixel at coordinate 65,5
    lcd.setPixel(65,6); //set a pixel at coordinate 65,6
    lcd.setPixel(65,7); //set a pixel at coordinate 65,7
    lcd.setPixel(64,8); //set a pixel at coordinate 64,8
    lcd.setPixel(64,9); //set a pixel at coordinate 64,9
    lcd.setPixel(64,10); //set a pixel at coordinate 64,10
    lcd.setPixel(64,11); //set a pixel at coordinate 64,11
    lcd.setPixel(64,12); //set a pixel at coordinate 61,12
    lcd.setPixel(63,13); //set a pixel at coordinate 63,13
    lcd.setPixel(63,14); //set a pixel at coordinate 63,14
    lcd.setPixel(63,15); //set a pixel at coordinate 63,15
    lcd.setPixel(63,16); //set a pixel at coordinate 63,16
    lcd.setPixel(63,17); //set a pixel at coordinate 63,17
    lcd.setPixel(62,18); //set a pixel at coordinate 62,18
    lcd.setPixel(62,19); //set a pixel at coordinate 62,19
    lcd.setPixel(62,20); //set a pixel at coordinate 62,20
    lcd.setPixel(62,21); //set a pixel at coordinate 62,21
    lcd.setPixel(61,21); //set a pixel at coordinate 61,21
    lcd.setPixel(60,21); //set a pixel at coordinate 60,21
    lcd.setPixel(59,21); //set a pixel at coordinate 59,21
    lcd.setPixel(58,21); //set a pixel at coordinate 58,21
    lcd.setPixel(57,21); //set a pixel at coordinate 57,21
    lcd.setPixel(56,21); //set a pixel at coordinate 56,21
    lcd.setPixel(55,21); //set a pixel at coordinate 55,21
    lcd.refresh(); //LCD Refresh
}

void object() //Draw object
{
    lcd.setPixel(71,4); //set a pixel at coordinate 71,4
    lcd.setPixel(72,4); //set a pixel at coordinate 72,4
    lcd.setPixel(73,4); //set a pixel at coordinate 73,4
    lcd.setPixel(74,4); //set a pixel at coordinate 74,4
    lcd.setPixel(75,4); //set a pixel at coordinate 75,4
    lcd.setPixel(76,4); //set a pixel at coordinate 76,4
    lcd.setPixel(77,4); //set a pixel at coordinate 77,4
    lcd.setPixel(78,4); //set a pixel at coordinate 78,4
    lcd.setPixel(79,4); //set a pixel at coordinate 79,4
    lcd.setPixel(71,5); //set a pixel at coordinate 71,5
    lcd.setPixel(72,5); //set a pixel at coordinate 72,5
    lcd.setPixel(74,5); //set a pixel at coordinate 74,5
    lcd.setPixel(76,5); //set a pixel at coordinate 76,5
    lcd.setPixel(78,5); //set a pixel at coordinate 78,5
    lcd.setPixel(79,5); //set a pixel at coordinate 79,5
    lcd.setPixel(71,6); //set a pixel at coordinate 71,6
    lcd.setPixel(73,6); //set a pixel at coordinate 73,6
    lcd.setPixel(75,6); //set a pixel at coordinate 75,6
    lcd.setPixel(77,6); //set a pixel at coordinate 77,6
    lcd.setPixel(79,6); //set a pixel at coordinate 79,6
    lcd.setPixel(71,7); //set a pixel at coordinate 71,7
    lcd.setPixel(72,7); //set a pixel at coordinate 72,7
    lcd.setPixel(74,7); //set a pixel at coordinate 74,7
    lcd.setPixel(76,7); //set a pixel at coordinate 76,7
    lcd.setPixel(78,7); //set a pixel at coordinate 78,7
    lcd.setPixel(79,7); //set a pixel at coordinate 79,7
    lcd.setPixel(70,8); //set a pixel at coordinate 70,9
    lcd.setPixel(71,8); //set a pixel at coordinate 71,8
    lcd.setPixel(73,8); //set a pixel at coordinate 73,8
    lcd.setPixel(75,8); //set a pixel at coordinate 75,8
    lcd.setPixel(77,8); //set a pixel at coordinate 77,8
    lcd.setPixel(78,8); //set a pixel at coordinate 78,8
    lcd.setPixel(70,9); //set a pixel at coordinate 70,9
    lcd.setPixel(72,9); //set a pixel at coordinate 72,9
    lcd.setPixel(74,9); //set a pixel at coordinate 74,9
    lcd.setPixel(76,9); //set a pixel at coordinate 76,9
    lcd.setPixel(78,9); //set a pixel at coordinate 78,9
    lcd.setPixel(70,10); //set a pixel at coordinate 70,10
    lcd.setPixel(71,10); //set a pixel at coordinate 71,10
    lcd.setPixel(73,10); //set a pixel at coordinate 73,10
    lcd.setPixel(75,10); //set a pixel at coordinate 75,10
    lcd.setPixel(77,10); //set a pixel at coordinate 77,10
    lcd.setPixel(78,10); //set a pixel at coordinate 78,10
    lcd.setPixel(70,11); //set a pixel at coordinate 70,11
    lcd.setPixel(72,11); //set a pixel at coordinate 72,11
    lcd.setPixel(74,11); //set a pixel at coordinate 74,11
    lcd.setPixel(76,11); //set a pixel at coordinate 76,11
    lcd.setPixel(78,11); //set a pixel at coordinate 78,11
    lcd.setPixel(70,12); //set a pixel at coordinate 70,12
    lcd.setPixel(71,12); //set a pixel at coordinate 71,12
    lcd.setPixel(73,12); //set a pixel at coordinate 73,12
    lcd.setPixel(75,12); //set a pixel at coordinate 75,12
    lcd.setPixel(77,12); //set a pixel at coordinate 77,12
    lcd.setPixel(78,12); //set a pixel at coordinate 78,12
    lcd.setPixel(69,13); //set a pixel at coordinate 69,13
    lcd.setPixel(70,13); //set a pixel at coordinate 70,13
    lcd.setPixel(72,13); //set a pixel at coordinate 72,13
    lcd.setPixel(74,13); //set a pixel at coordinate 74,13
    lcd.setPixel(76,13); //set a pixel at coordinate 76,13
    lcd.setPixel(77,13); //set a pixel at coordinate 77,13
    lcd.setPixel(69,14); //set a pixel at coordinate 69,14
    lcd.setPixel(71,14); //set a pixel at coordinate 71,14
    lcd.setPixel(73,14); //set a pixel at coordinate 73,14
    lcd.setPixel(75,14); //set a pixel at coordinate 75,14
    lcd.setPixel(77,14); //set a pixel at coordinate 77,14
    lcd.setPixel(69,15); //set a pixel at coordinate 69,15
    lcd.setPixel(70,15); //set a pixel at coordinate 70,15
    lcd.setPixel(72,15); //set a pixel at coordinate 72,15
    lcd.setPixel(74,15); //set a pixel at coordinate 74,15
    lcd.setPixel(76,15); //set a pixel at coordinate 76,15
    lcd.setPixel(77,15); //set a pixel at coordinate 77,15
    lcd.setPixel(69,16); //set a pixel at coordinate 69,16
    lcd.setPixel(71,16); //set a pixel at coordinate 71,16
    lcd.setPixel(73,16); //set a pixel at coordinate 73,16
    lcd.setPixel(75,16); //set a pixel at coordinate 75,16
    lcd.setPixel(77,16); //set a pixel at coordinate 77,16
    lcd.setPixel(69,17); //set a pixel at coordinate 69,17
    lcd.setPixel(70,17); //set a pixel at coordinate 70,17
    lcd.setPixel(72,17); //set a pixel at coordinate 72,17
    lcd.setPixel(74,17); //set a pixel at coordinate 74,17
    lcd.setPixel(76,17); //set a pixel at coordinate 76,17
    lcd.setPixel(77,17); //set a pixel at coordinate 77,17
    lcd.setPixel(68,18); //set a pixel at coordinate 68,18
    lcd.setPixel(69,18); //set a pixel at coordinate 69,18
    lcd.setPixel(71,18); //set a pixel at coordinate 71,18
    lcd.setPixel(73,18); //set a pixel at coordinate 73,18
    lcd.setPixel(75,18); //set a pixel at coordinate 75,18
    lcd.setPixel(76,18); //set a pixel at coordinate 76,18
    lcd.setPixel(68,19); //set a pixel at coordinate 68,19
    lcd.setPixel(70,19); //set a pixel at coordinate 70,19
    lcd.setPixel(72,19); //set a pixel at coordinate 72,19
    lcd.setPixel(74,19); //set a pixel at coordinate 74,19
    lcd.setPixel(76,19); //set a pixel at coordinate 76,19
    lcd.setPixel(68,20); //set a pixel at coordinate 68,20
    lcd.setPixel(69,20); //set a pixel at coordinate 69,20
    lcd.setPixel(71,20); //set a pixel at coordinate 71,20
    lcd.setPixel(73,20); //set a pixel at coordinate 73,20
    lcd.setPixel(75,20); //set a pixel at coordinate 75,20
    lcd.setPixel(76,20); //set a pixel at coordinate 76,20
    lcd.setPixel(68,21); //set a pixel at coordinate 68,21
    lcd.setPixel(69,21); //set a pixel at coordinate 69,21
    lcd.setPixel(70,21); //set a pixel at coordinate 70,21
    lcd.setPixel(71,21); //set a pixel at coordinate 71,21
    lcd.setPixel(72,21); //set a pixel at coordinate 72,21
    lcd.setPixel(73,21); //set a pixel at coordinate 73,21
    lcd.setPixel(74,21); //set a pixel at coordinate 74,21
    lcd.setPixel(75,21); //set a pixel at coordinate 75,21
    lcd.setPixel(76,21); //set a pixel at coordinate 76,21
    lcd.refresh(); //LCD refresh
}

void walls() //Draw Object
{
    safeWall(); //Draw safe zone
    cautionWall(); //Draw caution zone
    dangerWall(); //draw danger zone
    object(); //Draw object
}

void carDistance1() //Car x coordinate increment 
{
    a0 = 2; //Move pixel x coordinate to 2
    a1 = 3; //Move pixel x coordinate to 3
    a2 = 4; //Move pixel x coordinate to 4
    b0 = 10; //Move pixel x coordinate to 10
    b1 = 11; //Move pixel x coordinate to 11
    b2 = 12; //Move pixel x coordinate to 12
    b3 = 13; //Move pixel x coordinate to 13
    c0 = 19; //Move pixel x coordinate to 19
    c1 = 20; //Move pixel x coordinate to 20
    c2 = 21; //Move pixel x coordinate to 21
    d0 = 1; //Move pixel x coordinate to 1
    e0 = 21; //Move pixel x coordinate to 21
    e1 = 22; //Move pixel x coordinate to 22
    f0 = 1; //Move pixel x coordinate to 1
    g0 = 21; //Move pixel x coordinate to 21
    g1 = 22; //Move pixel x coordinate to 22
    h0 = 2; //Move pixel x coordinate to 2
    h1 = 3; //Move pixel x coordinate to 3
    h2 = 4; //Move pixel x coordinate to 4
    h3 = 5; //Move pixel x coordinate to 5
    i0 = 18; //Move pixel x coordinate to 18
    i1 = 19; //Move pixel x coordinate to 19
    i2 = 20; //Move pixel x coordinate to 20
    i3 = 21; //Move pixel x coordinate to 21
    j0 = 5; //Move pixel x coordinate to 5
    j1 = 6; //Move pixel x coordinate to 6
    k0 = 17; //Move pixel x coordinate to 17
    k1 = 18; //Move pixel x coordinate to 18
    l0 = 6; //Move pixel x coordinate to 6
    l1 = 7; //Move pixel x coordinate to 7
    m0 = 16; //Move pixel x coordinate to 16
    m1 = 17; //Move pixel x coordinate to 17
    n0 = 7; //Move pixel x coordinate to 7
    n1 = 8; //Move pixel x coordinate to 8
    o0 = 15; //Move pixel x coordinate to 15
    o1 = 16; //Move pixel x coordinate to 16
    q0 = 8; //Move pixel x coordinate to 8
    q1 = 9; //Move pixel x coordinate to 9
    q2 = 10; //Move pixel x coordinate to 10
    q3 = 11; //Move pixel x coordinate to 11
    q4 = 12; //Move pixel x coordinate to 12
    q5 = 13; //Move pixel x coordinate to 13
    q6 = 14; //Move pixel x coordinate to 14
    q7 = 15; //Move pixel x coordinate to 15
    w0 = 14; //Set front wheel width to 14
    w1 = 32; //Set rear wheel width to 32
}

void carDistance2() //Car x coordinate increment 2
{
    a0 = 5; //Move pixel x coordinate to 5
    a1 = 6; //Move pixel x coordinate to 6
    a2 = 7; //Move pixel x coordinate to 7
    b0 = 13; //Move pixel x coordinate to 13
    b1 = 14; //Move pixel x coordinate to 14
    b2 = 15; //Move pixel x coordinate to 15
    b3 = 16; //Move pixel x coordinate to 16
    c0 = 22; //Move pixel x coordinate to 22
    c1 = 23; //Move pixel x coordinate to 23
    c2 = 24; //Move pixel x coordinate to 24
    d0 = 4; //Move pixel x coordinate to 4
    e0 = 24; //Move pixel x coordinate to 24
    e1 = 25; //Move pixel x coordinate to 25
    f0 = 4; //Move pixel x coordinate to 4
    g0 = 24; //Move pixel x coordinate to 24
    g1 = 25; //Move pixel x coordinate to 25
    h0 = 5; //Move pixel x coordinate to 5
    h1 = 6; //Move pixel x coordinate to 6
    h2 = 7; //Move pixel x coordinate to 7
    h3 = 8; //Move pixel x coordinate to 8
    i0 = 21; //Move pixel x coordinate to 21
    i1 = 22; //Move pixel x coordinate to 22
    i2 = 23; //Move pixel x coordinate to 23
    i3 = 24; //Move pixel x coordinate to 24
    j0 = 8; //Move pixel x coordinate to 8
    j1 = 9; //Move pixel x coordinate to 9
    k0 = 20; //Move pixel x coordinate to 20
    k1 = 21; //Move pixel x coordinate to 21
    l0 = 9; //Move pixel x coordinate to 9
    l1 = 10; //Move pixel x coordinate to 10
    m0 = 19; //Move pixel x coordinate to 19
    m1 = 20; //Move pixel x coordinate to 20
    n0 = 10; //Move pixel x coordinate to 10
    n1 = 11; //Move pixel x coordinate to 11
    o0 = 18; //Move pixel x coordinate to 18
    o1 = 19; //Move pixel x coordinate to 19
    q0 = 11; //Move pixel x coordinate to 11
    q1 = 12; //Move pixel x coordinate to 12
    q2 = 13; //Move pixel x coordinate to 13
    q3 = 14; //Move pixel x coordinate to 14
    q4 = 15; //Move pixel x coordinate to 15
    q5 = 16; //Move pixel x coordinate to 16
    q6 = 17; //Move pixel x coordinate to 17
    q7 = 18; //Move pixel x coordinate to 18
    w0 = 20; //Set front wheel width to 20
    w1 = 38; //Set rear wheel width to 38
}

void carDistance3() //Car x coordinate increment 3
{
    a0 = 8; //Move pixel x coordinate to 8
    a1 = 9; //Move pixel x coordinate to 9
    a2 = 10; //Move pixel x coordinate to 10
    b0 = 16; //Move pixel x coordinate to 16
    b1 = 17; //Move pixel x coordinate to 17
    b2 = 18; //Move pixel x coordinate to 18
    b3 = 19; //Move pixel x coordinate to 19
    c0 = 25; //Move pixel x coordinate to 25
    c1 = 26; //Move pixel x coordinate to 26
    c2 = 27; //Move pixel x coordinate to 27
    d0 = 7; //Move pixel x coordinate to 7
    e0 = 27; //Move pixel x coordinate to 27
    e1 = 28; //Move pixel x coordinate to 28
    f0 = 7; //Move pixel x coordinate to 7
    g0 = 27; //Move pixel x coordinate to 27
    g1 = 28; //Move pixel x coordinate to 28
    h0 = 8; //Move pixel x coordinate to 8
    h1 = 9; //Move pixel x coordinate to 9
    h2 = 10; //Move pixel x coordinate to 10
    h3 = 11; //Move pixel x coordinate to 11
    i0 = 24; //Move pixel x coordinate to 24
    i1 = 25; //Move pixel x coordinate to 25
    i2 = 26; //Move pixel x coordinate to 26
    i3 = 27; //Move pixel x coordinate to 27
    j0 = 11; //Move pixel x coordinate to 11
    j1 = 12; //Move pixel x coordinate to 12
    k0 = 23; //Move pixel x coordinate to 23
    k1 = 24; //Move pixel x coordinate to 24
    l0 = 12; //Move pixel x coordinate to 12
    l1 = 13; //Move pixel x coordinate to 13
    m0 = 22; //Move pixel x coordinate to 22
    m1 = 23; //Move pixel x coordinate to 23
    n0 = 13; //Move pixel x coordinate to 13
    n1 = 14; //Move pixel x coordinate to 14
    o0 = 21; //Move pixel x coordinate to 21
    o1 = 22; //Move pixel x coordinate to 22
    q0 = 14; //Move pixel x coordinate to 14
    q1 = 15; //Move pixel x coordinate to 15
    q2 = 16; //Move pixel x coordinate to 16
    q3 = 17; //Move pixel x coordinate to 17
    q4 = 18; //Move pixel x coordinate to 18
    q5 = 19; //Move pixel x coordinate to 19
    q6 = 20; //Move pixel x coordinate to 20
    q7 = 21; //Move pixel x coordinate to 21
    w0 = 26; //Set front wheel width to 26
    w1 = 42; //Set rear wheel width to 42
}

void carDistance4() //Car x coordinate increment 4
{
    a0 = 11; //Move pixel x coordinate to 11
    a1 = 12; //Move pixel x coordinate to 12
    a2 = 13; //Move pixel x coordinate to 13
    b0 = 19; //Move pixel x coordinate to 19
    b1 = 20; //Move pixel x coordinate to 20
    b2 = 21; //Move pixel x coordinate to 21
    b3 = 22; //Move pixel x coordinate to 22
    c0 = 28; //Move pixel x coordinate to 28
    c1 = 29; //Move pixel x coordinate to 29
    c2 = 30; //Move pixel x coordinate to 30
    d0 = 10; //Move pixel x coordinate to 10
    e0 = 30; //Move pixel x coordinate to 30
    e1 = 31; //Move pixel x coordinate to 31
    f0 = 10; //Move pixel x coordinate to 10
    g0 = 30; //Move pixel x coordinate to 30
    g1 = 31; //Move pixel x coordinate to 31
    h0 = 11; //Move pixel x coordinate to 11
    h1 = 12; //Move pixel x coordinate to 12
    h2 = 13; //Move pixel x coordinate to 13
    h3 = 14; //Move pixel x coordinate to 14
    i0 = 27; //Move pixel x coordinate to 27
    i1 = 28; //Move pixel x coordinate to 28
    i2 = 29; //Move pixel x coordinate to 29
    i3 = 30; //Move pixel x coordinate to 30
    j0 = 14; //Move pixel x coordinate to 14
    j1 = 15; //Move pixel x coordinate to 15
    k0 = 26; //Move pixel x coordinate to 26
    k1 = 27; //Move pixel x coordinate to 27
    l0 = 15; //Move pixel x coordinate to 15
    l1 = 16; //Move pixel x coordinate to 16
    m0 = 25; //Move pixel x coordinate to 25
    m1 = 26; //Move pixel x coordinate to 26
    n0 = 16; //Move pixel x coordinate to 16
    n1 = 17; //Move pixel x coordinate to 17
    o0 = 24; //Move pixel x coordinate to 24
    o1 = 25; //Move pixel x coordinate to 25
    q0 = 17; //Move pixel x coordinate to 17
    q1 = 18; //Move pixel x coordinate to 18
    q2 = 19; //Move pixel x coordinate to 19
    q3 = 20; //Move pixel x coordinate to 20
    q4 = 21; //Move pixel x coordinate to 21
    q5 = 22; //Move pixel x coordinate to 22
    q6 = 23; //Move pixel x coordinate to 23
    q7 = 24; //Move pixel x coordinate to 24
    w0 = 32; //Set front wheel width to 32
    w1 = 48; //Set rear wheel width to 48
}

void carDistance5() //Car x coordinate increment 5
{
    a0 = 14; //Move pixel x coordinate to 14
    a1 = 15; //Move pixel x coordinate to 15
    a2 = 16; //Move pixel x coordinate to 16
    b0 = 22; //Move pixel x coordinate to 22
    b1 = 23; //Move pixel x coordinate to 23
    b2 = 24; //Move pixel x coordinate to 24
    b3 = 25; //Move pixel x coordinate to 25
    c0 = 31; //Move pixel x coordinate to 31
    c1 = 32; //Move pixel x coordinate to 32
    c2 = 33; //Move pixel x coordinate to 33
    d0 = 13; //Move pixel x coordinate to 13
    e0 = 33; //Move pixel x coordinate to 33
    e1 = 34; //Move pixel x coordinate to 34
    f0 = 13; //Move pixel x coordinate to 13
    g0 = 33; //Move pixel x coordinate to 33
    g1 = 34; //Move pixel x coordinate to 34
    h0 = 14; //Move pixel x coordinate to 14
    h1 = 15; //Move pixel x coordinate to 15
    h2 = 16; //Move pixel x coordinate to 16
    h3 = 17; //Move pixel x coordinate to 17
    i0 = 30; //Move pixel x coordinate to 30
    i1 = 31; //Move pixel x coordinate to 31
    i2 = 32; //Move pixel x coordinate to 32
    i3 = 33; //Move pixel x coordinate to 33
    j0 = 17; //Move pixel x coordinate to 17
    j1 = 18; //Move pixel x coordinate to 18
    k0 = 29; //Move pixel x coordinate to 29
    k1 = 30; //Move pixel x coordinate to 30
    l0 = 18; //Move pixel x coordinate to 18
    l1 = 19; //Move pixel x coordinate to 19
    m0 = 28; //Move pixel x coordinate to 28
    m1 = 29; //Move pixel x coordinate to 29
    n0 = 19; //Move pixel x coordinate to 19
    n1 = 20; //Move pixel x coordinate to 20
    o0 = 27; //Move pixel x coordinate to 27
    o1 = 28; //Move pixel x coordinate to 28
    q0 = 20; //Move pixel x coordinate to 20
    q1 = 21; //Move pixel x coordinate to 21
    q2 = 22; //Move pixel x coordinate to 22
    q3 = 23; //Move pixel x coordinate to 23
    q4 = 24; //Move pixel x coordinate to 24
    q5 = 25; //Move pixel x coordinate to 25
    q6 = 26; //Move pixel x coordinate to 26
    q7 = 27; //Move pixel x coordinate to 27
    w0 = 38; //Set front wheel width to 38
    w1 = 54; //Set rear wheel width to 54
}

void carDistance6() //Car x coordinate increment 6
{
    a0 = 17; //Move pixel x coordinate to 17
    a1 = 18; //Move pixel x coordinate to 18
    a2 = 19; //Move pixel x coordinate to 19
    b0 = 25; //Move pixel x coordinate to 25
    b1 = 26; //Move pixel x coordinate to 26
    b2 = 27; //Move pixel x coordinate to 27
    b3 = 28; //Move pixel x coordinate to 28
    c0 = 34; //Move pixel x coordinate to 34
    c1 = 35; //Move pixel x coordinate to 35
    c2 = 36; //Move pixel x coordinate to 36
    d0 = 16; //Move pixel x coordinate to 16
    e0 = 36; //Move pixel x coordinate to 36
    e1 = 37; //Move pixel x coordinate to 37
    f0 = 16; //Move pixel x coordinate to 16
    g0 = 36; //Move pixel x coordinate to 36
    g1 = 37; //Move pixel x coordinate to 37
    h0 = 17; //Move pixel x coordinate to 17
    h1 = 18; //Move pixel x coordinate to 18
    h2 = 19; //Move pixel x coordinate to 19
    h3 = 20; //Move pixel x coordinate to 20
    i0 = 33; //Move pixel x coordinate to 33
    i1 = 34; //Move pixel x coordinate to 34
    i2 = 35; //Move pixel x coordinate to 35
    i3 = 36; //Move pixel x coordinate to 36
    j0 = 20; //Move pixel x coordinate to 20
    j1 = 21; //Move pixel x coordinate to 21
    k0 = 32; //Move pixel x coordinate to 32
    k1 = 33; //Move pixel x coordinate to 33
    l0 = 21; //Move pixel x coordinate to 21
    l1 = 22; //Move pixel x coordinate to 22
    m0 = 31; //Move pixel x coordinate to 31
    m1 = 32; //Move pixel x coordinate to 32
    n0 = 22; //Move pixel x coordinate to 22
    n1 = 23; //Move pixel x coordinate to 23
    o0 = 30; //Move pixel x coordinate to 30
    o1 = 31; //Move pixel x coordinate to 31
    q0 = 23; //Move pixel x coordinate to 23
    q1 = 24; //Move pixel x coordinate to 24
    q2 = 25; //Move pixel x coordinate to 25
    q3 = 26; //Move pixel x coordinate to 26
    q4 = 27; //Move pixel x coordinate to 27
    q5 = 28; //Move pixel x coordinate to 28
    q6 = 29; //Move pixel x coordinate to 29
    q7 = 30; //Move pixel x coordinate to 30
    w0 = 44; //Set front wheel width to 44
    w1 = 60; //Set rear wheel width to 60
}

void carDistance7() //Car x coordinate increment 7
{
    a0 = 20; //Move pixel x coordinate to 20
    a1 = 21; //Move pixel x coordinate to 21
    a2 = 22; //Move pixel x coordinate to 22
    b0 = 28; //Move pixel x coordinate to 28
    b1 = 29; //Move pixel x coordinate to 29
    b2 = 30; //Move pixel x coordinate to 30
    b3 = 31; //Move pixel x coordinate to 31
    c0 = 37; //Move pixel x coordinate to 37
    c1 = 38; //Move pixel x coordinate to 38
    c2 = 39; //Move pixel x coordinate to 39
    d0 = 19; //Move pixel x coordinate to 19
    e0 = 39; //Move pixel x coordinate to 39
    e1 = 40; //Move pixel x coordinate to 40
    f0 = 19; //Move pixel x coordinate to 19
    g0 = 39; //Move pixel x coordinate to 39
    g1 = 40; //Move pixel x coordinate to 40
    h0 = 20; //Move pixel x coordinate to 20
    h1 = 21; //Move pixel x coordinate to 21
    h2 = 22; //Move pixel x coordinate to 22
    h3 = 23; //Move pixel x coordinate to 23
    i0 = 36; //Move pixel x coordinate to 36
    i1 = 37; //Move pixel x coordinate to 37
    i2 = 38; //Move pixel x coordinate to 38
    i3 = 39; //Move pixel x coordinate to 39
    j0 = 23; //Move pixel x coordinate to 23
    j1 = 24; //Move pixel x coordinate to 24
    k0 = 35; //Move pixel x coordinate to 35
    k1 = 36; //Move pixel x coordinate to 36
    l0 = 24; //Move pixel x coordinate to 24
    l1 = 25; //Move pixel x coordinate to 25
    m0 = 34; //Move pixel x coordinate to 34
    m1 = 35; //Move pixel x coordinate to 35
    n0 = 25; //Move pixel x coordinate to 25
    n1 = 26; //Move pixel x coordinate to 26
    o0 = 33; //Move pixel x coordinate to 33
    o1 = 34; //Move pixel x coordinate to 34
    q0 = 26; //Move pixel x coordinate to 26
    q1 = 27; //Move pixel x coordinate to 27
    q2 = 28; //Move pixel x coordinate to 28
    q3 = 29; //Move pixel x coordinate to 29
    q4 = 30; //Move pixel x coordinate to 30
    q5 = 31; //Move pixel x coordinate to 31
    q6 = 32; //Move pixel x coordinate to 32
    q7 = 33; //Move pixel x coordinate to 33
    w0 = 50; //Set front wheel width to 50
    w1 = 66; //Set rear wheel width to 66
}

void carDistance8() //Car x coordinate increment 8
{
    a0 = 23; //Move pixel x coordinate to 23
    a1 = 24; //Move pixel x coordinate to 24
    a2 = 25; //Move pixel x coordinate to 25
    b0 = 31; //Move pixel x coordinate to 31
    b1 = 32; //Move pixel x coordinate to 32
    b2 = 33; //Move pixel x coordinate to 33
    b3 = 34; //Move pixel x coordinate to 34
    c0 = 40; //Move pixel x coordinate to 40
    c1 = 41; //Move pixel x coordinate to 41
    c2 = 42; //Move pixel x coordinate to 42
    d0 = 22; //Move pixel x coordinate to 22
    e0 = 42; //Move pixel x coordinate to 42
    e1 = 43; //Move pixel x coordinate to 43
    f0 = 22; //Move pixel x coordinate to 22
    g0 = 42; //Move pixel x coordinate to 42
    g1 = 43; //Move pixel x coordinate to 43
    h0 = 23; //Move pixel x coordinate to 23
    h1 = 24; //Move pixel x coordinate to 24
    h2 = 25; //Move pixel x coordinate to 25
    h3 = 26; //Move pixel x coordinate to 26
    i0 = 39; //Move pixel x coordinate to 39
    i1 = 40; //Move pixel x coordinate to 40
    i2 = 41; //Move pixel x coordinate to 41
    i3 = 42; //Move pixel x coordinate to 42
    j0 = 26; //Move pixel x coordinate to 26
    j1 = 27; //Move pixel x coordinate to 27
    k0 = 38; //Move pixel x coordinate to 38
    k1 = 39; //Move pixel x coordinate to 39
    l0 = 27; //Move pixel x coordinate to 27
    l1 = 28; //Move pixel x coordinate to 28
    m0 = 37; //Move pixel x coordinate to 37
    m1 = 38; //Move pixel x coordinate to 38
    n0 = 28; //Move pixel x coordinate to 28
    n1 = 29; //Move pixel x coordinate to 29
    o0 = 36; //Move pixel x coordinate to 36
    o1 = 37; //Move pixel x coordinate to 37
    q0 = 29; //Move pixel x coordinate to 29
    q1 = 30; //Move pixel x coordinate to 30
    q2 = 31; //Move pixel x coordinate to 31
    q3 = 32; //Move pixel x coordinate to 32
    q4 = 33; //Move pixel x coordinate to 33
    q5 = 34; //Move pixel x coordinate to 34
    q6 = 35; //Move pixel x coordinate to 35
    q7 = 36; //Move pixel x coordinate to 36
    w0 = 56; //Set front wheel width to 56
    w1 = 72; //Set rear wheel width to 72
}

void carDistance9() //Car x coordinate increment 9
{
    a0 = 26; //Move pixel x coordinate to 26
    a1 = 27; //Move pixel x coordinate to 27
    a2 = 28; //Move pixel x coordinate to 28
    b0 = 34; //Move pixel x coordinate to 34
    b1 = 35; //Move pixel x coordinate to 35
    b2 = 36; //Move pixel x coordinate to 36
    b3 = 37; //Move pixel x coordinate to 37
    c0 = 43; //Move pixel x coordinate to 43
    c1 = 44; //Move pixel x coordinate to 44
    c2 = 45; //Move pixel x coordinate to 45
    d0 = 25; //Move pixel x coordinate to 25
    e0 = 45; //Move pixel x coordinate to 45
    e1 = 46; //Move pixel x coordinate to 46
    f0 = 25; //Move pixel x coordinate to 25
    g0 = 45; //Move pixel x coordinate to 45
    g1 = 46; //Move pixel x coordinate to 46
    h0 = 26; //Move pixel x coordinate to 26
    h1 = 27; //Move pixel x coordinate to 27
    h2 = 28; //Move pixel x coordinate to 28
    h3 = 29; //Move pixel x coordinate to 29
    i0 = 42; //Move pixel x coordinate to 42
    i1 = 43; //Move pixel x coordinate to 43
    i2 = 44; //Move pixel x coordinate to 44
    i3 = 45; //Move pixel x coordinate to 45
    j0 = 29; //Move pixel x coordinate to 29
    j1 = 30; //Move pixel x coordinate to 30
    k0 = 41; //Move pixel x coordinate to 41
    k1 = 42; //Move pixel x coordinate to 42
    l0 = 30; //Move pixel x coordinate to 30
    l1 = 31; //Move pixel x coordinate to 31
    m0 = 40; //Move pixel x coordinate to 40
    m1 = 41; //Move pixel x coordinate to 41
    n0 = 31; //Move pixel x coordinate to 31
    n1 = 32; //Move pixel x coordinate to 32
    o0 = 39; //Move pixel x coordinate to 39
    o1 = 40; //Move pixel x coordinate to 40
    q0 = 32; //Move pixel x coordinate to 32
    q1 = 33; //Move pixel x coordinate to 33
    q2 = 34; //Move pixel x coordinate to 34
    q3 = 35; //Move pixel x coordinate to 35
    q4 = 36; //Move pixel x coordinate to 36
    q5 = 37; //Move pixel x coordinate to 37
    q6 = 38; //Move pixel x coordinate to 38
    q7 = 39; //Move pixel x coordinate to 39
    w0 = 62; //Set front wheel width to 62
    w1 = 78; //Set rear wheel width to 78
}

void carDistance10() //Car x coordinate increment 10
{
    a0 = 29; //Move pixel x coordinate to 29
    a1 = 30; //Move pixel x coordinate to 30
    a2 = 31; //Move pixel x coordinate to 31
    b0 = 37; //Move pixel x coordinate to 37
    b1 = 38; //Move pixel x coordinate to 38
    b2 = 39; //Move pixel x coordinate to 39
    b3 = 40; //Move pixel x coordinate to 40
    c0 = 46; //Move pixel x coordinate to 46
    c1 = 47; //Move pixel x coordinate to 47
    c2 = 48; //Move pixel x coordinate to 48
    d0 = 28; //Move pixel x coordinate to 28
    e0 = 48; //Move pixel x coordinate to 48
    e1 = 49; //Move pixel x coordinate to 49
    f0 = 28; //Move pixel x coordinate to 28
    g0 = 48; //Move pixel x coordinate to 48
    g1 = 49; //Move pixel x coordinate to 49
    h0 = 29; //Move pixel x coordinate to 29
    h1 = 30; //Move pixel x coordinate to 30
    h2 = 31; //Move pixel x coordinate to 31
    h3 = 32; //Move pixel x coordinate to 32
    i0 = 45; //Move pixel x coordinate to 45
    i1 = 46; //Move pixel x coordinate to 46
    i2 = 47; //Move pixel x coordinate to 47
    i3 = 48; //Move pixel x coordinate to 48
    j0 = 32; //Move pixel x coordinate to 32
    j1 = 33; //Move pixel x coordinate to 33
    k0 = 44; //Move pixel x coordinate to 44
    k1 = 45; //Move pixel x coordinate to 45
    l0 = 33; //Move pixel x coordinate to 33
    l1 = 34; //Move pixel x coordinate to 34
    m0 = 43; //Move pixel x coordinate to 43
    m1 = 44; //Move pixel x coordinate to 44
    n0 = 34; //Move pixel x coordinate to 34
    n1 = 35; //Move pixel x coordinate to 35
    o0 = 42; //Move pixel x coordinate to 42
    o1 = 43; //Move pixel x coordinate to 43
    q0 = 35; //Move pixel x coordinate to 35
    q1 = 36; //Move pixel x coordinate to 36
    q2 = 37; //Move pixel x coordinate to 37
    q3 = 38; //Move pixel x coordinate to 38
    q4 = 39; //Move pixel x coordinate to 39
    q5 = 40; //Move pixel x coordinate to 40
    q6 = 41; //Move pixel x coordinate to 41
    q7 = 42; //Move pixel x coordinate to 42
    w0 = 68; //Set front wheel width to 68
    w1 = 84; //Set rear wheel width to 84
}

void carDistance11() //Car x coordinate increment 11
{
    a0 = 32; //Move pixel x coordinate to 32
    a1 = 33; //Move pixel x coordinate to 33
    a2 = 34; //Move pixel x coordinate to 34
    b0 = 40; //Move pixel x coordinate to 40
    b1 = 41; //Move pixel x coordinate to 41
    b2 = 42; //Move pixel x coordinate to 42
    b3 = 43; //Move pixel x coordinate to 43
    c0 = 49; //Move pixel x coordinate to 49
    c1 = 50; //Move pixel x coordinate to 50
    c2 = 51; //Move pixel x coordinate to 51
    d0 = 31; //Move pixel x coordinate to 31
    e0 = 51; //Move pixel x coordinate to 51
    e1 = 52; //Move pixel x coordinate to 52
    f0 = 31; //Move pixel x coordinate to 31
    g0 = 51; //Move pixel x coordinate to 51
    g1 = 52; //Move pixel x coordinate to 52
    h0 = 32; //Move pixel x coordinate to 32
    h1 = 33; //Move pixel x coordinate to 33
    h2 = 34; //Move pixel x coordinate to 34
    h3 = 35; //Move pixel x coordinate to 35
    i0 = 48; //Move pixel x coordinate to 48
    i1 = 49; //Move pixel x coordinate to 49
    i2 = 50; //Move pixel x coordinate to 50
    i3 = 51; //Move pixel x coordinate to 51
    j0 = 35; //Move pixel x coordinate to 35
    j1 = 36; //Move pixel x coordinate to 36
    k0 = 47; //Move pixel x coordinate to 47
    k1 = 48; //Move pixel x coordinate to 48
    l0 = 36; //Move pixel x coordinate to 36
    l1 = 37; //Move pixel x coordinate to 37
    m0 = 46; //Move pixel x coordinate to 46
    m1 = 47; //Move pixel x coordinate to 47
    n0 = 37; //Move pixel x coordinate to 37
    n1 = 38; //Move pixel x coordinate to 38
    o0 = 45; //Move pixel x coordinate to 45
    o1 = 46; //Move pixel x coordinate to 46
    q0 = 38; //Move pixel x coordinate to 38
    q1 = 39; //Move pixel x coordinate to 39
    q2 = 40; //Move pixel x coordinate to 40
    q3 = 41; //Move pixel x coordinate to 41
    q4 = 42; //Move pixel x coordinate to 42
    q5 = 43; //Move pixel x coordinate to 43
    q6 = 44; //Move pixel x coordinate to 44
    q7 = 45; //Move pixel x coordinate to 45
    w0 = 74; //Set front wheel width to 74
    w1 = 90; //Set rear wheel width to 90
}

void carDistance12() //Car x coordinate increment 12
{
    a0 = 35; //Move pixel x coordinate to 35
    a1 = 36; //Move pixel x coordinate to 36
    a2 = 37; //Move pixel x coordinate to 37
    b0 = 43; //Move pixel x coordinate to 43
    b1 = 44; //Move pixel x coordinate to 44
    b2 = 45; //Move pixel x coordinate to 45
    b3 = 46; //Move pixel x coordinate to 46
    c0 = 52; //Move pixel x coordinate to 52
    c1 = 53; //Move pixel x coordinate to 53
    c2 = 54; //Move pixel x coordinate to 54
    d0 = 34; //Move pixel x coordinate to 34
    e0 = 54; //Move pixel x coordinate to 54
    e1 = 55; //Move pixel x coordinate to 55
    f0 = 34; //Move pixel x coordinate to 34
    g0 = 54; //Move pixel x coordinate to 54
    g1 = 55; //Move pixel x coordinate to 55
    h0 = 35; //Move pixel x coordinate to 35
    h1 = 36; //Move pixel x coordinate to 36
    h2 = 37; //Move pixel x coordinate to 37
    h3 = 38; //Move pixel x coordinate to 38
    i0 = 51; //Move pixel x coordinate to 51
    i1 = 52; //Move pixel x coordinate to 52
    i2 = 53; //Move pixel x coordinate to 3
    i3 = 54; //Move pixel x coordinate to 54
    j0 = 38; //Move pixel x coordinate to 38
    j1 = 39; //Move pixel x coordinate to 39
    k0 = 50; //Move pixel x coordinate to 50
    k1 = 51; //Move pixel x coordinate to 51
    l0 = 39; //Move pixel x coordinate to 39
    l1 = 40; //Move pixel x coordinate to 40
    m0 = 49; //Move pixel x coordinate to 49
    m1 = 50; //Move pixel x coordinate to 50
    n0 = 40; //Move pixel x coordinate to 40
    n1 = 41; //Move pixel x coordinate to 41
    o0 = 48; //Move pixel x coordinate to 48
    o1 = 49; //Move pixel x coordinate to 49
    q0 = 41; //Move pixel x coordinate to 41
    q1 = 42; //Move pixel x coordinate to 42
    q2 = 43; //Move pixel x coordinate to 43
    q3 = 44; //Move pixel x coordinate to 44
    q4 = 45; //Move pixel x coordinate to 45
    q5 = 46; //Move pixel x coordinate to 46
    q6 = 47; //Move pixel x coordinate to 47
    q7 = 48; //Move pixel x coordinate to 48
    w0 = 80; //Set front wheel width to 80
    w1 = 96; //Set rear wheel width to 96
}

void carDistance13() //Car x coordinate increment 13
{
    a0 = 38; //Move pixel x coordinate to 38
    a1 = 39; //Move pixel x coordinate to 39
    a2 = 40; //Move pixel x coordinate to 40
    b0 = 46; //Move pixel x coordinate to 46
    b1 = 47; //Move pixel x coordinate to 47
    b2 = 48; //Move pixel x coordinate to 48
    b3 = 49; //Move pixel x coordinate to 49
    c0 = 55; //Move pixel x coordinate to 55
    c1 = 56; //Move pixel x coordinate to 56
    c2 = 57; //Move pixel x coordinate to 57
    d0 = 37; //Move pixel x coordinate to 37
    e0 = 57; //Move pixel x coordinate to 57
    e1 = 58; //Move pixel x coordinate to 58
    f0 = 37; //Move pixel x coordinate to 37
    g0 = 57; //Move pixel x coordinate to 57
    g1 = 58; //Move pixel x coordinate to 58
    h0 = 38; //Move pixel x coordinate to 38
    h1 = 39; //Move pixel x coordinate to 39
    h2 = 40; //Move pixel x coordinate to 40
    h3 = 41; //Move pixel x coordinate to 41
    i0 = 54; //Move pixel x coordinate to 54
    i1 = 55; //Move pixel x coordinate to 55
    i2 = 56; //Move pixel x coordinate to 56
    i3 = 57; //Move pixel x coordinate to 57
    j0 = 41; //Move pixel x coordinate to 41
    j1 = 42; //Move pixel x coordinate to 42
    k0 = 53; //Move pixel x coordinate to 53
    k1 = 54; //Move pixel x coordinate to 54
    l0 = 42; //Move pixel x coordinate to 42
    l1 = 43; //Move pixel x coordinate to 43
    m0 = 52; //Move pixel x coordinate to 52
    m1 = 53; //Move pixel x coordinate to 53
    n0 = 43; //Move pixel x coordinate to 43
    n1 = 44; //Move pixel x coordinate to 44
    o0 = 51; //Move pixel x coordinate to 51
    o1 = 52; //Move pixel x coordinate to 52
    q0 = 44; //Move pixel x coordinate to 44
    q1 = 45; //Move pixel x coordinate to 45
    q2 = 46; //Move pixel x coordinate to 46
    q3 = 47; //Move pixel x coordinate to 47
    q4 = 48; //Move pixel x coordinate to 48
    q5 = 49; //Move pixel x coordinate to 49
    q6 = 50; //Move pixel x coordinate to 50
    q7 = 51; //Move pixel x coordinate to 51
    w0 = 86; //Set front wheel width to 86
    w1 = 102; //Set rear wheel width to 102
}

void carDistance14() //Car x coordinate increment 14
{
    a0 = 41; //Move pixel x coordinate to 41
    a1 = 42; //Move pixel x coordinate to 42
    a2 = 43; //Move pixel x coordinate to 43
    b0 = 49; //Move pixel x coordinate to 49
    b1 = 50; //Move pixel x coordinate to 50
    b2 = 51; //Move pixel x coordinate to 51
    b3 = 52; //Move pixel x coordinate to 52
    c0 = 58; //Move pixel x coordinate to 58
    c1 = 59; //Move pixel x coordinate to 59
    c2 = 60; //Move pixel x coordinate to 60
    d0 = 40; //Move pixel x coordinate to 40
    e0 = 60; //Move pixel x coordinate to 60
    e1 = 61; //Move pixel x coordinate to 61
    f0 = 40; //Move pixel x coordinate to 40
    g0 = 60; //Move pixel x coordinate to 60
    g1 = 61; //Move pixel x coordinate to 61
    h0 = 41; //Move pixel x coordinate to 41
    h1 = 42; //Move pixel x coordinate to 42
    h2 = 43; //Move pixel x coordinate to 43
    h3 = 44; //Move pixel x coordinate to 44
    i0 = 57; //Move pixel x coordinate to 57
    i1 = 58; //Move pixel x coordinate to 58
    i2 = 59; //Move pixel x coordinate to 59
    i3 = 60; //Move pixel x coordinate to 60
    j0 = 44; //Move pixel x coordinate to 44
    j1 = 45; //Move pixel x coordinate to 45
    k0 = 56; //Move pixel x coordinate to 56
    k1 = 57; //Move pixel x coordinate to 57
    l0 = 45; //Move pixel x coordinate to 45
    l1 = 46; //Move pixel x coordinate to 46
    m0 = 55; //Move pixel x coordinate to 55
    m1 = 56; //Move pixel x coordinate to 56
    n0 = 46; //Move pixel x coordinate to 46
    n1 = 47; //Move pixel x coordinate to 47
    o0 = 54; //Move pixel x coordinate to 54
    o1 = 55; //Move pixel x coordinate to 55
    q0 = 47; //Move pixel x coordinate to 47
    q1 = 48; //Move pixel x coordinate to 48
    q2 = 49; //Move pixel x coordinate to 49
    q3 = 50; //Move pixel x coordinate to 50
    q4 = 51; //Move pixel x coordinate to 51
    q5 = 52; //Move pixel x coordinate to 52
    q6 = 53; //Move pixel x coordinate to 53
    q7 = 54; //Move pixel x coordinate to 54
    w0 = 92; //Set front wheel width to 92
    w1 = 108; //Set rear wheel width to 108
}

void carDistance15() //Car x coordinate increment 15
{
    a0 = 44; //Move pixel x coordinate to 44
    a1 = 45; //Move pixel x coordinate to 45
    a2 = 46; //Move pixel x coordinate to 46
    b0 = 52; //Move pixel x coordinate to 52
    b1 = 53; //Move pixel x coordinate to 53
    b2 = 54; //Move pixel x coordinate to 54
    b3 = 55; //Move pixel x coordinate to 55
    c0 = 61; //Move pixel x coordinate to 61
    c1 = 62; //Move pixel x coordinate to 62
    c2 = 63; //Move pixel x coordinate to 63
    d0 = 43; //Move pixel x coordinate to 43
    e0 = 63; //Move pixel x coordinate to 63
    e1 = 64; //Move pixel x coordinate to 64
    f0 = 43; //Move pixel x coordinate to 43
    g0 = 63; //Move pixel x coordinate to 63
    g1 = 64; //Move pixel x coordinate to 64
    h0 = 44; //Move pixel x coordinate to 44
    h1 = 45; //Move pixel x coordinate to 45
    h2 = 46; //Move pixel x coordinate to 46
    h3 = 47; //Move pixel x coordinate to 47
    i0 = 60; //Move pixel x coordinate to 60
    i1 = 61; //Move pixel x coordinate to 61
    i2 = 62; //Move pixel x coordinate to 62
    i3 = 63; //Move pixel x coordinate to 63
    j0 = 47; //Move pixel x coordinate to 47
    j1 = 48; //Move pixel x coordinate to 48
    k0 = 59; //Move pixel x coordinate to 59
    k1 = 60; //Move pixel x coordinate to 60
    l0 = 48; //Move pixel x coordinate to 48
    l1 = 49; //Move pixel x coordinate to 49
    m0 = 58; //Move pixel x coordinate to 58
    m1 = 59; //Move pixel x coordinate to 59
    n0 = 49; //Move pixel x coordinate to 49
    n1 = 50; //Move pixel x coordinate to 50
    o0 = 57; //Move pixel x coordinate to 57
    o1 = 58; //Move pixel x coordinate to 58
    q0 = 50; //Move pixel x coordinate to 50
    q1 = 51; //Move pixel x coordinate to 51
    q2 = 52; //Move pixel x coordinate to 52
    q3 = 53; //Move pixel x coordinate to 53
    q4 = 54; //Move pixel x coordinate to 54
    q5 = 55; //Move pixel x coordinate to 55
    q6 = 56; //Move pixel x coordinate to 56
    q7 = 57; //Move pixel x coordinate to 57
    w0 = 98; //Set front wheel width to 98
    w1 = 114; //Set rear wheel width to 114
}