#include "mbed.h"
#include "uLCD_4D_Picaso.h"

/**
* Demo program for uLCD_4D_Picaso resistance touchscreen 
* Simple Graphing Application on resistive touchscreen display
* @version 1.0
* @author Andrew McRae, Tianhao Li
*/
// three pins are: TX   RX  RESET
uLCD_4D_Picaso lcd(p28, p27, p30);
//
int main() {
    wait(1);
    // change the baudrate to improve or decrease the latency and plotting quality
    lcd.setbaudWait(Picaso::BAUD_600000);
    lcd.touch_Set(0);
    lcd.txt_Opacity(Picaso::OPAQUE);
    lcd.gfx_RectangleFilled(200, 0, 230, 30, Picaso::WHITE);
    lcd.gfx_RectangleFilled(0, 0, 30, 30, Picaso::WHITE);
    lcd.txt_MoveCursor(1, 1);
    lcd.putCH('E');
    int status = 0;
    int x = 0;
    int y = 0;
    int eraserActive = 0;
    int prevX, prevY;
    while(1) {
        status = lcd.touch_Get(0);
        if (status)
        {
            x = lcd.touch_Get(1);
            y = lcd.touch_Get(2);
            if (status == 1 && x >= 200 && y <= 30) {
                // Clear screen
                // Redraw eraser and clear screen button.
                lcd.gfx_Cls();
                lcd.gfx_RectangleFilled(200, 0, 230, 30, Picaso::WHITE);
                lcd.gfx_RectangleFilled(0, 0, 30, 30, Picaso::WHITE);
                lcd.txt_MoveCursor(0, 0);
                lcd.putCH('E');
            } else if (status == 1 && x <= 40 && y <= 30) {
                  eraserActive = !eraserActive;
            } else {
                if (eraserActive) {
                    lcd.gfx_RectangleFilled(x - 10, y - 10, x + 10, y + 10, Picaso::BLACK);
                } else {
                    if (status == 1) {
                        prevX = x;
                        prevY = y;
                    }

                    // Moving, draw a continuous line until release event happen
                    lcd.gfx_Line(prevX, prevY, x, y, Picaso::WHITE);
                }
            }    

            prevX = x;
            prevY = y;
   
        }    
    }
}    
