#include "mbed.h"
#include "USBKeyboard.h"
#include "PinDetect.h"

USBKeyboard keyboard;

PinDetect button1(D4); // Left
PinDetect button2(D5); // Right
PinDetect button3(D6); // Space
PinDetect button4(D7); // Shift

DigitalOut myled(LED1);

int state[4];

void button1_pressed() {
    state[0] = 1;
}
void button2_pressed() {
    state[1] = 1;
}
void button3_pressed() {
    state[2] = 1;
}
void button4_pressed() {
    state[3] = 1;
}

void button1_released() {
    state[0] = 0;
}
void button2_released() {
    state[1] = 0;
}
void button3_released() {
    state[2] = 0;
}
void button4_released() {
    state[3] = 0;
}

void exec_keycode(int state[], USBKeyboard keyboard) {
    if (state[0] == 1) {
        keyboard.keyCode('a');
    }
    if (state[1] == 1) {
        keyboard.keyCode('d');
    }
    if (state[2] == 1) {
        keyboard.keyCode(32);
    }
    if (state[3] == 1) {
        keyboard.keyCode(16);
    }
}

int main() {

    /*Add callback functions for events when buttons are pressed. */
    button1.attach_asserted(&button1_pressed);
    button2.attach_asserted(&button2_pressed);
    button3.attach_asserted(&button3_pressed);
    button4.attach_asserted(&button4_pressed);

    /*Add callback functions for events when buttons are released. */
    button1.attach_deasserted(&button1_released);
    button2.attach_deasserted(&button2_released);
    button3.attach_deasserted(&button3_released);
    button4.attach_deasserted(&button4_released);

    button1.setAssertValue(0);
    button2.setAssertValue(0);
    button3.setAssertValue(0);
    button4.setAssertValue(0);

    button1.setSampleFrequency();
    button2.setSampleFrequency();
    button3.setSampleFrequency();
    button4.setSampleFrequency();
    
    for (;;) {
        if (state[0] == 1) {
            keyboard.keyCode('a');
        }
        if (state[1] == 1) {
            keyboard.keyCode('d');
        }
        if (state[2] == 1) {
            keyboard.keyCode(32);
        }
        if (state[3] == 1) {
            keyboard.keyCode(16);
        }
        wait(0.1);
    }
}