/// Values stored in flash, which are modifieable by user actions ///

#ifndef USER_CONFIG_H
#define USER_CONFIG_H

//MOTOR INT PARAMS 
#define NPP                     21 //__int_reg[200]                                  //TODO --> FIX ISSUES w/ THIS IN FLASH , ask @adi, Number of motor Pole Pairs  

//OFFSET PARAMS / OTHER PARAMS
#define E_OFFSET                __float_reg[0]                                  // Encoder electrical offset
#define M_OFFSET                __float_reg[1]                                  // Encoder mechanical offset
#define I_BW                    __float_reg[2]                                  // Current loop bandwidth
#define I_MAX                   __float_reg[3]                                  // Torque limit (current limit = torque_limit/(kt*gear ratio))
#define THETA_MIN               __float_reg[4]                                  // Minimum position setpoint
#define THETA_MAX               __float_reg[5]                                  // Maximum position setpoint
#define I_FW_MAX                __float_reg[6]                                  // Maximum field weakening current
#define R_NOMINAL               __float_reg[7]                                  // Nominal motor resistance, set during calibration
#define TEMP_MAX                __float_reg[8]                                  // Temperature safety lmit
#define I_MAX_CONT              __float_reg[9]                                  // Continuous max current
#define K_SCALE                 __float_reg[10]                                 // Current Controller KP scaled w/ BW
#define KI_D                    __float_reg[11]                                 // Current Controller KI D-Axis
#define KI_Q                    __float_reg[12]                                 // Current Controller KI Q-Axis

//MOTOR PARAMETERS MOVED TO FLASH
#define R_PHASE                 __float_reg[13]                                 //Phase resistance in OHMS
#define L_D                     __float_reg[14]                                 //D-axis inductance in HENRIES
#define L_Q                     __float_reg[15]                                 //L-axis inductance in HENRIES
//ACTUATOR PARAMETERS
#define KT                      __float_reg[16]                                 //Torque Constance Nm/peak phase amp, = WB*NPP*3/2
#define GR                      __float_reg[17]                                 //Output gear ratio
#define KT_OUT                  __float_reg[18]                                 //KT*GR
#define WB                      __float_reg[19]                                 //Flux linkage, Webers.  (from motor KT, see above formula)
//THERMAL OBSERVER
#define R_TH                    __float_reg[20]                                 //Kelvin watt per joule (motor thermal resistance)
#define INV_M_TH                __float_reg[21]                                 //Kelvin per Joule (some observer thing)
#define T_AMBIENT               __float_reg[22]                                 // ambient temperature during temp calibration


#define PHASE_ORDER             __int_reg[0]                                    // Phase swapping during calibration
#define CAN_ID                  __int_reg[1]                                    // CAN bus ID
#define CAN_MASTER              __int_reg[2]                                    // CAN bus "master" ID
#define CAN_TIMEOUT             __int_reg[3]                                    // CAN bus timeout period
#define ENCODER_LUT             __int_reg[5]                                    // Encoder offset LUT - 128 elements long



extern float __float_reg[];
extern int __int_reg[];

#endif
