#ifndef MOTOR_CONFIG_U12_H
#define MOTOR_CONFIG_U12_H


// CONFIGURATION PARAMETERS FOR U12 MOTORS

#define R_PHASE 0.158f            //Ohms
#define L_D 0.000084f             //Henries
#define L_Q 0.000084f             //Henries
#define NPP 21                    //Number of pole pairs  

#define KT 0.1916f                 //N-m per peak phase amp, = WB*NPP*3/2
#define GR 6.0f                   //Gear ratio
#define KT_OUT 1.15f             //KT*GR
#define WB 0.00608f // from KT     //Flux linkage, Webers.  

#define R_TH 1.25f  //needs update            //Kelvin per watt
#define INV_M_TH 0.02825f //needs update      //Kelvin per joule
#define T_AMBIENT 25.0f           // ambient temperature during temp calibration

// U12 motor is KV40...use to calculate Kt
// actuator has 36 stator slots, 42 pole magnets
// so, 21 elec revs per mech rev
// 36*21 steps per elec rev if using traditional commutation

#endif
