#ifndef MOTOR_CONFIG_U10_H
#define MOTOR_CONFIG_U10_H

// CONFIGURATION PARAMETERS OF U10 MOTORS

#define R_PHASE 0.433f            //Ohms
#define L_D 0.0002f               //Henries
#define L_Q 0.0002f             //Henries, set both inductances equal for now
#define NPP 21                    //Number of pole pairs   

#define KT 0.2028f                 //N-m per peak phase amp, = WB*NPP*3/2   
#define GR 6.0f                   //Gear ratio
#define KT_OUT 1.2168f             //KT*GR
#define WB 0.00606f // from KT    //Flux linkage, Webers.
  
#define R_TH 1.25f  //needs update            //Kelvin per watt
#define INV_M_TH 0.02825f //needs update      //Kelvin per joule
#define T_AMBIENT 25.0f           // ambient temperature during temp calibration

// U10 motor is KV50...use to calculate Kt
// actuator has 36 stator slots, 42 pole magnets
// so, 21 elec revs per mech rev
// 36*21 steps per elec rev if using traditional commutation

#endif
