#include "mbed.h"
#include "math_ops.h"

#define MIN -5.0f
#define MAX 5.0f

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

//setup SERIAL
Serial       pc(PA_2, PA_3);

//setup analog inputs
AnalogIn torque_sense(PC_0);
float SENSE_CONV_FACTOR = 10.0; //-10v to 10v --> -100Nm to 100Nm
float SYSTEM_VOLTAGE = 3.3; //volts

//moving average filter
#define M_POINTS 2
float points[M_POINTS] = {0.0, 0.0};

//setup CAN
CAN          can(PA_11, PA_12, 1000000);  // CAN Rx pin name, CAN Tx pin name
CANMessage   tauMsg;
int                     ledState;
Ticker                  sendCAN;
int                     counter = 0;
volatile bool           msgAvailable = false;
Ticker loop;

float MOVING_AVERAGE(float new_point) {
        //first let's update the object points and calculate the SUM
        float SUM = 0.0;
        int i;
        for ( i = 0; i < M_POINTS-1; i = i + 1) {
               points[i] = points[i+1];
               SUM = SUM + points[i];
        }
        points[M_POINTS-1] = new_point;
        SUM = SUM + new_point;
        return SUM / float(M_POINTS);
    }

void pack_cmd(CANMessage * msg, float f1){
     /// convert floats to unsigned ints ///
     uint16_t f1_int = float_to_uint(f1, MIN, MAX, 16);            
     msg->data[0] = f1_int>>8;                                       
     msg->data[1] = f1_int&0xFF;
     }

int main()
{
    wait(1);
    pc.baud(115200);
    wait(.01);
    pc.printf("\n\r\n\r Biomimetics Torque Sense Board\n\r\n\r");
    wait(.01);
    
    tauMsg.len = 2;                        //transmit 4 bytes
    tauMsg.id = 0x1;                       //higher priority                
    
    while(1){
        //wait(0.0003); //MAKE SURE IT's 1-3k rate, higher we will fill the CAN buffer
        float v_tau = torque_sense.read()*SYSTEM_VOLTAGE;                                  //PUBLISH
        float tau = v_tau;
        
        //calc the moving average
        //tau = MOVING_AVERAGE(tau);
        
        //pc.printf("%f\n", tau);
        
        //now we have to publish the float to the CAN BUS
        pack_cmd(&tauMsg, tau);
        can.write(tauMsg);
        wait(.00002);
    }
}
