#include "mbed.h"
#include "math_ops.h"

#define MIN -400.0f
#define MAX 400.0f

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

//setup SERIAL
Serial       pc(PA_2, PA_3);

//setup scaling
float HV_CURRENT_SCALING = 0.0400; //V/A
float LV_CURRENT_SCALING = 0.0550; //V/A
float SYSTEM_VOLTAGE = 3.3; //volts
float VCC = 5.0; //volts
float EXT_CURRENT_SCALING = 0.008; //Sensitivity = 8mv/A external sensor

//setup analog inputs
AnalogIn hv_current(PC_0);
AnalogIn lv_current(PC_1);
AnalogIn voltage_sense(PC_2);
AnalogIn ext_current_A(PC_3); //V_OUT (for now)
AnalogIn ext_current_B(PC_4); //V_REF (for now)
//setup CAN
CAN          can(PA_11, PA_12, 1000000);  // CAN Rx pin name, CAN Tx pin name
CANMessage   currMsg, statMsg;
int                     ledState;
Ticker                  sendCAN;
int                     counter = 0;
volatile bool           msgAvailable = false;
Ticker loop;

void pack_cmd(CANMessage * msg, float f1, float f2){
     /// convert floats to unsigned ints ///
     uint16_t f1_int = float_to_uint(f1, MIN, MAX, 16);            
     uint16_t f2_int = float_to_uint(f2, MIN, MAX, 16);
     /// pack ints into the can buffer ///
     msg->data[0] = f1_int>>8;                                       
     msg->data[1] = f1_int&0xFF;
     msg->data[2] = f2_int>>8;
     msg->data[3] = f2_int&0xFF;
     }

int main()
{
    wait(1);
    pc.baud(115200);
    wait(.01);
    pc.printf("\n\r\n\r Biomimetics Power Board\n\r\n\r");
    wait(.01);
    
    currMsg.len = 4;                        //transmit 4 bytes
    statMsg.len = 4;                        //transmit 4 bytes
    
    currMsg.id = 0x1;                       //higher priority                
    statMsg.id = 0x2;                     //lower priority
    
    while(1){
        wait(0.0003); //MAKE SURE IT's 1-3k rate, higher we will fill the CAN buffer
        float hv_cur = float((hv_current.read()*SYSTEM_VOLTAGE-VCC/2.0) / HV_CURRENT_SCALING);                                     //PUBLISH
        float lv_cur = float((lv_current.read()*SYSTEM_VOLTAGE-VCC/2.0) / LV_CURRENT_SCALING);                                     //PUBLISH
        float vol = (voltage_sense.read()*SYSTEM_VOLTAGE); //*67.232-96.149;                                                       //PUBLISH
        
        float V_OUT_EXT = (ext_current_A.read()*SYSTEM_VOLTAGE);
        float V_REF_EXT = (ext_current_B.read()*SYSTEM_VOLTAGE);
        
        float ext_cur = (V_OUT_EXT-V_REF_EXT) / EXT_CURRENT_SCALING;                            //PUBLISH
        
        //pc.printf("Volts: %f\n", vol);
        
        //now we have to publish the four floats to the CAN BUS
        pack_cmd(&currMsg, hv_cur, ext_cur);
        pack_cmd(&statMsg, vol, lv_cur);
        can.write(currMsg);
        wait(.00002);
        can.write(statMsg); 
    }
}
