#include "mbed.h"
#include "math_ops.h"

#define MIN -400.0f
#define MAX 400.0f

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

//setup SERIAL
Serial       pc(PA_2, PA_3);

//setup scaling
float TORQUE_SCALING = 0.0550; //V/A

//setup analog inputs
AnalogIn hv_current(PC_0);

//setup CAN
CAN          can(PA_11, PA_12, 1000000);  // CAN Rx pin name, CAN Tx pin name
CANMessage   tauMsg;
int                     ledState;
Ticker                  sendCAN;
int                     counter = 0;
volatile bool           msgAvailable = false;
Ticker loop;

void pack_cmd(CANMessage * msg, float f1){
     /// convert floats to unsigned ints ///
     uint16_t f1_int = float_to_uint(f1, MIN, MAX, 16);            
     //uint16_t f2_int = float_to_uint(f2, MIN, MAX, 16);
     /// pack ints into the can buffer ///
     msg->data[0] = f1_int>>8;                                       
     msg->data[1] = f1_int&0xFF;
     /*
     msg->data[2] = f2_int>>8;
     msg->data[3] = f2_int&0xFF;
     msg->data[4] = 0x00;
     msg->data[5] = 0x00;
     msg->data[6] = 0x00;
     msg->data[7] = 0x00;
     */
     }

int main()
{
    wait(1);
    pc.baud(115200);
    wait(.01);
    pc.printf("\n\r\n\r Biomimetics Torque Sense Board\n\r\n\r");
    wait(.01);
    
    tauMsg.len = 2;                        //transmit 4 bytes
    tauMsg.id = 0x2;                       //higher priority                
    
    while(1){
        //wait(1); //GET RID OF THIS WAIT LATER
        float hv_cur = (hv_current.read()*SYSTEM_VOLTAGE-VCC/2.0) / HV_CURRENT_SCALING;                                     //PUBLISH
        float lv_cur = (lv_current.read()*SYSTEM_VOLTAGE-VCC/2.0) / LV_CURRENT_SCALING;                                     //PUBLISH
        float vol = (voltage_sense.read()*SYSTEM_VOLTAGE)*VOL_SENSE_SCALING; //INACCURATE ON THE HARDWARE SIDE!!!           //PUBLISH
        
        float V_OUT_EXT = (ext_current_A.read()*SYSTEM_VOLTAGE);
        float V_REF_EXT = (ext_current_B.read()*SYSTEM_VOLTAGE);
        
        float ext_cur = (V_OUT_EXT*SYSTEM_VOLTAGE-V_REF_EXT*SYSTEM_VOLTAGE) / EXT_CURRENT_SCALING;                            //PUBLISH
        
        //now we have to publish the four floats to the CAN BUS
        pack_cmd(&tauMsg, hv_cur);
        can.write(tauMsg);
        wait(.00002);
    }
}
