#ifndef _leg_message
#define _leg_message

#include <stdint.h>

// 9*2 bytes = 18 16-bit words 36 8-bit words
// 9 32-bit numbers
struct spi_data_t
{
    float q_1s[2];
    float qd_1s[2];
    float tau_1s[2];
    int32_t flags[2];
    uint32_t checksum;
};

// 13*2 bytes = 26 16-bit words 52 8-bit words
// 13 32-bit numbers
struct spi_command_t
{
    float q_des_1s[2]; //first motor on each can bus 0-can1, 1-can2, 2-can3
    float qd_des_1s[2];
    float kp_1s[2];
    float kd_1s[2];
    float tau_1s_ff[2];
    int32_t flags[2];
    uint32_t checksum;
};



struct joint_control{
    float p_des, v_des, kp, kd, t_ff;
    };
    
struct joint_state{
    float p, v, t;
    };
    
struct grouped_act_state{
    joint_state a1; //removed a2 and a3
    };
struct grouped_act_control{
    joint_control a1;
    }
    ;
#endif