
//counter for misc purposes
int counter3 = 0;
                                                                                    //GO THROUGH AND RE-CHECK ALL THE VARIABLES, STRUCT NAMES, SIZES, BUFFERS + ETC!!!
                                                                                    //ALSO GO THROUGH THE COMMENTS TO SEE IF THEY NEED CHANGING

#include "mbed.h"
#include "math_ops.h"
#include <cstring>
#include "leg_message.h"

// length of receive/transmit buffers
#define RX_LEN 12                                                                   //CHECK THESE BUFFER LENGHTS
#define TX_LEN 12 

// length of outgoing/incoming messages
#define CMD_LEN 12 
#define DATA_LEN 12                                                                 //CHECK THESE BUFFER LENGHTS

// Master CAN ID ///
#define CAN_ID 0x0


/// Value Limits ///
#define MIN_CUR -400.0f
#define MAX_CUR 400.0f

#define MIN_TAU -5.0f
#define MAX_TAU 5.0f

spi_data_t spi_data; // data from spine to up

// spi buffers
uint16_t rx_buff[RX_LEN];
uint16_t tx_buff[TX_LEN];

DigitalOut led(PC_5);


Serial       pc(PA_2, PA_3);
CAN          can1(PA_11, PA_12, 1000000);
CAN          can2(PA_8, PA_15, 1000000);
//CAN          can3(PB_12, PB_13, 1000000); //corresponds to bus 1-3-6 (controller 1) or 2-4-5 (controller 2) IN THAT ORDER

CANMessage   rxMsg1, rxMsg2;
int                     ledState;
Ticker                  sendCAN;
int                     counter = 0;
volatile bool           msgAvailable = false;
Ticker loop;

int spi_enabled = 0;
InterruptIn cs(PA_4);
DigitalIn estop(PB_15);

void unpack_reply_4bit(CANMessage msg, spi_data_t * spi_data){
    //rx2msg is the data from the torque board (CAN2)
    //rx1msg is the data from the upboard (CAN1)
        
    /// unpack ints from can buffer ///
    uint16_t id = msg.id;
    uint16_t u1 = (msg.data[0]<<8)|msg.data[1];
    uint16_t u2 = (msg.data[2]<<8)|msg.data[3];
    
    /// convert uints to floats ///
    float f1 = uint_to_float(u1, MIN_CUR, MAX_CUR, 16);
    float f2 = uint_to_float(u2, MIN_CUR, MAX_CUR, 16);
    
    if(id==1){
        spi_data->hv_current = f1;
        spi_data->ext_current = f2;
        //pc.printf("ext_current: %f\n", f2);
        }
    if(id==2){
        spi_data->vol = f1;
        spi_data->lv_current = f2;
        }
    } 
    
void unpack_reply_2bit(CANMessage msg, spi_data_t * spi_data){
    //rx2msg is the data from the torque board (CAN2)
    //rx1msg is the data from the upboard (CAN1)
    
    /// unpack ints from can buffer ///
    //uint16_t id = msg.id;
    uint16_t tau = (msg.data[0]<<8)|msg.data[1];
    /// convert uints to floats ///
    float t = uint_to_float(tau, MIN_TAU, MAX_TAU, 16);
    //pc.printf("torque: %f\n", t);
    spi_data->tau = t;
}

 void rxISR1() {
    can1.read(rxMsg1);                    // read message into Rx message storage
    unpack_reply_4bit(rxMsg1, &spi_data);
}
void rxISR2(){
    can2.read(rxMsg2);
    unpack_reply_2bit(rxMsg2, &spi_data);
    }
    
uint32_t xor_checksum(uint32_t* data, size_t len)
{
    uint32_t t = 0;
    for(int i = 0; i < len; i++)   
        t = t ^ data[i];
    return t;
}

void update_buffers(void) {
    //spi_data.checksum = 100;        
    spi_data.checksum = xor_checksum((uint32_t*)&spi_data,4); //only do first 16 bytes
    for(int i = 0; i < DATA_LEN; i++){
        tx_buff[i] = ((uint16_t*)(&spi_data))[i];}
}

void spi_isr(void)
{
    //pc.printf("CS ACTIVE\n");
    GPIOC->ODR |= (1 << 8);
    GPIOC->ODR &= ~(1 << 8);
    int bytecount = 0;
    SPI1->DR = tx_buff[0];
    while(cs == 0) {
        if(SPI1->SR&0x1) {
            rx_buff[bytecount] = SPI1->DR;
            bytecount++;
            if(bytecount<TX_LEN) {
                SPI1->DR = tx_buff[bytecount];
            }
        }
    }
    
    update_buffers();
}

void init_spi(void){
    SPISlave *spi = new SPISlave(PA_7, PA_6, PA_5, PA_4);
    spi->format(16, 0);
    spi->frequency(12000000);
    spi->reply(0x0);
    cs.fall(&spi_isr);
    pc.printf("done\n\r");
}
    
int main() {
    wait(1);
    //led = 1;
    pc.baud(115200);                                                                //MAYBE CHANGE THIS IF NEEDED
    estop.mode(PullUp);
    //spi.format(16, 0);
    //spi.frequency(1000000);
    //spi.reply(0x0);
    //cs.fall(&spi_isr);

    //can1.frequency(1000000);                     // set bit rate to 1Mbps
    //can1.attach(&rxISR1);                 // attach 'CAN receive-complete' interrupt handler
    can1.filter(CAN_ID<<21, 0xFFE00004, CANStandard, 0); //set up can filter
    //can2.frequency(1000000);                     // set bit rate to 1Mbps
    //can2.attach(&rxISR2);                 // attach 'CAN receive-complete' interrupt handler
    can2.filter(CAN_ID<<21, 0xFFE00004, CANStandard, 0); //set up can filter

    memset(&tx_buff, 0, TX_LEN * sizeof(uint16_t));
    memset(&rx_buff, 0, RX_LEN * sizeof(uint16_t));
    memset(&spi_data, 0, sizeof(spi_data_t));
    

    NVIC_SetPriority(TIM5_IRQn, 1);
    
    pc.printf("\n\r SPIne SENSOR\n\r");
    //printf("%d\n\r", RX_ID << 18);
    
    //RECIEVE
    rxMsg1.len = 4;                          //receive 4 bytes
    rxMsg2.len = 2;
    
    //just debugging things
    pc.printf("SETUP VARS ALL DONE\n");

    // SPI doesn't work if enabled while the CS pin is pulled low
    // Wait for CS to not be low, then enable SPI

    if(!spi_enabled){ 
        while((spi_enabled==0) && (cs.read() ==0)){pc.printf("waiting for CS Pin\n"); wait_us(10);}
        init_spi();
        spi_enabled = 1;
        pc.printf("SPI ENABLED AND READY\n");
        }
        
    //spi_command=set the thing here... 
            
    while(1) {
        //pc.printf("test, of SPINE\r\n");
        //wait(0.0001); //MAKE SURE IT's 1-3k rate, higher we will fill the CAN buffer
        
        counter++;
        can2.read(rxMsg2);
        unpack_reply_2bit(rxMsg2, &spi_data);
        can1.read(rxMsg1);                    // read message into Rx message storage
        unpack_reply_4bit(rxMsg1, &spi_data);
        //wait_us(10);
        //wait(0.01);
        
        }

}