#ifndef _leg_message
#define _leg_message

#include <stdint.h>

// 31*4 bytes = 124 8-bit words
// 31 32-bit numbers
struct spi_data_t
{
    float q_1s[3];
    float q_2s[3];
    float q_3s[3];
    float qd_1s[3];
    float qd_2s[3];
    float qd_3s[3];
    float tau_1s[3];
    float tau_2s[3];
    float tau_3s[3];
    uint32_t flags[3];
    uint32_t checksum;
};

// 49*4 bytes = 196 8-bit words
// 49 32-bit numbers
struct spi_command_t
{
    float q_des_1s[3]; //first motor on each can bus 0-can1, 1-can2, 2-can3
    float q_des_2s[3];
    float q_des_3s[3];
    float qd_des_1s[3];
    float qd_des_2s[3];
    float qd_des_3s[3];
    float kp_1s[3];
    float kp_2s[3];
    float kp_3s[3];
    float kd_1s[3];
    float kd_2s[3];
    float kd_3s[3];
    float tau_1s_ff[3];
    float tau_2s_ff[3];
    float tau_3s_ff[3];
    uint32_t flags[3];
    uint32_t checksum;
};



struct joint_control{
    float p_des, v_des, kp, kd, t_ff;
    };
    
struct joint_state{
    float p, v, t;
    };
    
struct grouped_act_state{
    joint_state a1; //removed a2 and a3
    };
struct grouped_act_control{
    joint_control a1;
    }
    ;
#endif