//
// Constants for the MAX-8U
//

#ifndef HAMSTER_MAX8UCONSTANTS_H
#define HAMSTER_MAX8UCONSTANTS_H

// Characters at the start of every UBX message
#define UBX_SYNC_CHAR_1 0xB5
#define UBX_SYNC_CHAR_2 0x62

// indicies into UBX messages
#define UBX_BYTE_CLASS 2
#define UBX_BYTE_ID 3

#define UBX_DATA_OFFSET 6 // start byte of message data
#define UBX_HEADER_FOOTER_LENGTH 8 // length of message header and footer

// class ACK
#define UBX_CLASS_ACK 0x5
#define UBX_ACK_NACK 0x0
#define UBX_ACK_ACK 0x1

// class CFG
#define UBX_CLASS_CFG 0x6
#define UBX_CFG_PRT 0x0
#define UBX_CFG_MSG 0x1
#define UBX_CFG_RATE 0x8
#define UBX_CFG_CFG 0x9
#define UBX_CFG_GNSS 0x3E

// class NAV
#define UBX_CLASS_NAV 0x1
#define UBX_NAV_POSLLH 0x2 // LLH stands for Latitude-Longitude-Height
#define UBX_NAV_SOL 0x06
#define UBX_NAV_TIMEUTC 0x21
#define UBX_NAV_SAT 0x35
#define UBX_NAV_VELNED 0x12

// class MON
#define UBX_CLASS_MON 0xA
#define UBX_MON_VER 0x4
#define UBX_MON_HW 0x9

#define UBX_MESSAGE_START_CHAR 0xB5
#define NMEA_MESSAGE_START_CHAR '$'

#endif //HAMSTER_MAX8UCONSTANTS_H
