//Example Usage of MAX8U Driver


#include "MAX8U.h"

int main(){
    MAX8U gps(&pc, PIN_I2C_SDA, PIN_I2C_SCL, p25);
    bool booted = gps.begin();

    if(!booted){
        //handle error
    }
    booted = gps.configure();
    if(!booted){
        //handle error
    }

    while(true){
        bool newMessageRcvd = gps.update();
        pc.printf(">Position: %.06f %c, %.06f %c, Height %.02f m\r\n",
                  std::abs(gps.latitude), gps.latitude > 0 ? 'N' : 'S',
                  std::abs(gps.longitude), gps.longitude > 0 ? 'E' : 'W',
                  gps.height);

        // velocity
        pc.printf(">Velocity: %.02f m/s N, %.02f m/s E, %.02f m/s Down\r\n",
                  gps.northVel * .02f,
                  gps.eastVel * .02f,
                  gps.downVel * .02f);

        // accuracy
        pc.printf(">Fix: Quality: %" PRIu8 ", Num Satellites: %" PRIu8 ", Position Accuracy: %.02f m\r\n",
                static_cast<uint8_t>(gps.fixQuality), gps.numSatellites, gps.posAccuracy);

        // time
        pc.printf(">Time: %" PRIu8 "/%" PRIu8"/%" PRIu16" %" PRIu8":%" PRIu8 ":%" PRIu8 "\r\n",
                gps.month,
                gps.day,
                gps.year,
                gps.hour,
                gps.minute,
                gps.second);
    }
}
