/**
 * XBee Example Test
 * A test application that demonstrates the ability
 * of transmitting serial data via an XBee module with
 * an mbed microprocesor.
 * By: Vlad Cazan
 * Date: Tuesday, September 29th 2009
 */

#include "mbed.h"
#include "rtos.h"
#include <string>
#include <vector>

Serial xbee1(p9, p10); //Creates a variable for serial comunication through pin 9 and 10
DigitalOut rst1(p11); //Digital reset for the XBee, 200ns for reset
DigitalOut myled(LED3);//Create variable for Led 3 on the mbed
DigitalOut myled2(LED4);//Create variable for Led 4 on the mbed
vector<string> studentNames;
vector<string> serialNumbers;
vector<string> studentIds;
Serial pc(USBTX, USBRX);//Opens up serial communication through the USB port via the computer
char c;
PinName _tx = p9;
PinName _rx = p10;

int ConfigMode()
{
    int a;
    Serial DATA(_tx,_rx);
    wait(2);
    DATA.printf("+++");
    while (a != 75) {
        if (DATA.readable()) {
            a = DATA.getc();
        }
    }
    wait(1);
    printf("Configuration Complete!\n\n");
    return 1;
}

int GetSerial(int *serial_no)
{
    //pc.printf("Start - GetSerial");
    int sh1,sh2,sh3,sl1,sl2,sl3,sl4;
    Serial DATA(_tx,_rx);
    wait_ms(50);
    DATA.printf("ATSL \r");
    DATA.scanf ("%2x%2x%2x%2x",&sl1,&sl2,&sl3,&sl4);
    wait_ms(500);
    DATA.printf("ATSH \r");
    DATA.scanf ("%2x%2x%2x",&sh1,&sh2,&sh3);
 
    serial_no[0] = sh1;
    serial_no[1] = sh2;
    serial_no[2] = sh3;
    serial_no[3] = sl1;
    serial_no[4] = sl2;
    serial_no[5] = sl3;
    serial_no[6] = sl4;
    //pc.printf("End - GetSerial");
    return 1;
}

int SetKey(char* key)
{
    //pc.printf("Start - SetKey");
    Serial DATA(_tx,_rx);
    DATA.printf("ATEE 0 \r");
    char sec_key[8] = {'h','e','l','l','o','m','o','b'};
    DATA.scanf ("%*s");
    wait_ms(1);
    DATA.printf("ATKY %s \r",sec_key);
    DATA.scanf ("%*s");
    //pc.printf("End - SetKey");
    return 1;
}

int SetPanId(int pan_id)
{
    //pc.printf("Start - PanId");
    Serial DATA(_tx,_rx);
    wait_ms(5);
    DATA.printf("ATID %i\r",pan_id);
    DATA.scanf ("%*s");
    //pc.printf("End - PanID");
    return 1;
}

int WriteSettings()
{
    //pc.printf("Start - WriteSettings");
    Serial DATA(_tx,_rx);
    wait_ms(5);
    DATA.printf("ATWR \r");
    DATA.scanf ("%*s");
    //pc.printf("End - WriteSettings");
    return 1;
}

int ExitConfigMode()
{
    //pc.printf("Start - ExitConfig");
    Serial DATA(_tx,_rx);
    wait_ms(5);
    DATA.printf("ATCN \r");
    DATA.scanf ("%*s");
    //pc.printf("End - ExitConfig");
    return 1;
}

void Reset()
{
    //pc.printf("Start - Reset");
    rst1 = 0;
    wait_ms(10);
    rst1 = 1;
    wait_ms(1);
    //pc.printf("End - Reset");
}

int read_sentence(char* input){

    char tmp;
    while(!pc.readable());
    tmp = pc.getc();
    pc.putc(tmp);
    int counter = 0;
    while(tmp != '\n'){
        input[counter] = tmp;
        if(pc.readable()){
            tmp = pc.getc();
            pc.putc(tmp);
            counter++;
        } 
    }
    
    pc.printf("\n");
    return counter-1;
}

int read_xbee_sentence(char* input){
    char tmp;
    while(!xbee1.readable());
    tmp = xbee1.getc();
    int counter = 0;
    while(tmp != '\n'){
        input[counter] = tmp;
        if(xbee1.readable()){
            tmp = xbee1.getc();
            counter++;
        } 
    }
    return counter;
}

void print_assessment_available(void const *args){
  pc.printf("Broadcasting assessment available message to all the clickers in the room!\n");
  while(1){
   xbee1.printf("Available\n");
   Thread::wait(100);
  }
}

int main() {
    rst1 = 0; //Set reset pin to 0
    myled = 0;//Set LED3 to 0
    myled2= 0;//Set LED4 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond
    pc.printf("Teacher Machine\n");
    pc.printf("Start a new assessment? (y/n)\n");
    char sentence_store[255];
    char begin_assessment = 'o';
    char temp;
    int char_count;
    while(begin_assessment == 'o'){
      if(pc.readable()){
         temp = pc.getc();   
      }
      if(temp == 'y' || temp == 'n' || temp == 'Y' || temp == 'N'){
         begin_assessment = temp;   
      }
    }
    pc.putc(begin_assessment);
    pc.printf("\n");
    if(begin_assessment == 'n' || begin_assessment == 'N'){
      pc.printf("Ok. This program will exit momentarily");   
    }else{
        pc.printf("Great! The assessment process begins!\n");
        pc.printf("We are configuring a few things. Wait for a few seconds!\n");
        int device_serial[8];
        char sec_key[8] = {'h','e','l','l','o','m','o','b'};
        int pan_id = 5;
        int assessment_id = rand() % 100 + 1;
        ConfigMode();
        GetSerial(device_serial);
        SetKey(sec_key);
        SetPanId(pan_id);
        WriteSettings();
        //ExitConfigMode();
        Reset();
        pc.printf("Your students will need these parameters to configure their clickers!\n");
        pc.printf("Channel Number: %d\n", pan_id);
        pc.printf("How many questions are going to be in the assessment?\n");
        char_count = read_sentence(sentence_store);
        int number_of_questions;
        number_of_questions = atoi (sentence_store);
        char answer_store[number_of_questions];
        pc.printf("Please enter the correct answer for each of the questions\n");
        for(int j = 0;j < number_of_questions; j++){
            pc.printf("Question %d - Correct Answer: ",j+1);
            read_sentence(sentence_store);
            answer_store[j] = sentence_store[0];
            pc.printf("\n");   
        }
        pc.printf("Great! The answer key is now set!\n");
        pc.printf("The system will start accepting connections\n");
        pc.printf("Waiting for student clickers to connect!\n");
        //Thread t(&print_assessment_available);
        int attack_detector = 0;
        while (1) {//Neverending Loop
             // if(pc.readable()){
            if (xbee1.readable()){
               string input;
               char poll_id[255];
               char_count = read_xbee_sentence(poll_id);
               char set_poll_id[char_count];
               for(int i = 0;i < char_count; i++){
                    set_poll_id[i] = poll_id[i];    
               }
               input = string(set_poll_id);
               pc.printf(input.c_str());
               pc.printf("\n");
               if(input.find("C-") != -1 && attack_detector == 0){
                 int cdash = input.find_last_of("-");
                 pc.printf("A clicker with #%s is trying to connect\n",input.substr(cdash+1,input.length()-1).c_str());
                 pc.printf("NReq-%s\n",input.substr(cdash+1,input.length()-1).c_str());
                 xbee1.printf("NReq-%s\n",input.substr(cdash+1,input.length()-1).c_str());
                 attack_detector++;
                 pc.printf("%d",attack_detector);   
               }else if(input.find("NRes-") != -1 && attack_detector == 1){
                 pc.printf("The student %s has begun his/her assessment\n",input.substr(15,input.length()-1).c_str());
                 pc.printf("Requesting his/her ID number\n");
                 int length = input.length();
                 int ndash = input.find_last_of("-");
                 pc.printf("IDReq-%s\n",input.substr(15,length-1).c_str());
                 xbee1.printf("IDReq-%s\n",input.substr(15,length-1).c_str());
                 attack_detector++; 
               }else if(input.find("IDRes-") != -1 && attack_detector == 2){
                 pc.printf(input.c_str());
                 pc.printf("The student's ID number is %s\n",input.substr(6,input.length()-1).c_str());
                 pc.printf("Sending the clicker the question number count\n");
                 pc.printf("QC-%d-%d\n",assessment_id,number_of_questions);
                 xbee1.printf("QC-%d-%d\n",assessment_id,number_of_questions);
                 attack_detector++;   
               }else if(input.find("QA-") != -1 && attack_detector == 3){
                 pc.printf("Question count has been acknowledged!\n");
                 pc.printf("Now waiting for answers to be sent!\n");
                 attack_detector++;    
               } else if(input.find("ANS-") != -1 && attack_detector == 4){
                 pc.printf("Answers from the clicker has been received!\n");
                 int dash = input.find_last_of("-");
                 string k = input.substr(dash+1,input.length()-1);
                 string answer_key;
                 answer_key = string(answer_store);
                 int correct = 0;
                 for(int i = 0; i < answer_key.length(); i++){
                    if(answer_key[i] == k[i]){
                      correct++;   
                    }
                 }
                 float grade = (float) (correct/number_of_questions)*100.0;
                 pc.printf("Output grade - %f\n", grade);
                 xbee1.printf("GRADE-%f",grade);
                 attack_detector++;
                } else if(input.find("AA") != -1){
                  xbee1.printf("Available\n");   
                }
            }
        }
     }
}