/**
 * XBee Example Test
 * A test application that demonstrates the ability
 * of transmitting serial data via an XBee module with
 * an mbed microprocesor.
 * By: Vlad Cazan
 * Date: Tuesday, September 29th 2009
 */

#include "mbed.h"
#include <string>
#include "MODSERIAL.h"

Serial xbee1(p9, p10); //Creates a variable for serial comunication through pin 9 and 10
MODSERIAL xbee(p9,p10);
DigitalOut rst1(p11); //Digital reset for the XBee, 200ns for reset
DigitalOut myled(LED3);//Create variable for Led 3 on the mbed
DigitalOut myled2(LED4);//Create variable for Led 4 on the mbed
int char_count;
Serial pc(USBTX, USBRX);//Opens up serial communication through the USB port via the computer
char c;
PinName _tx = p9;
PinName _rx = p10;

int ConfigMode()
{
    int a;
    Serial DATA(_tx,_rx);
    wait(2);
    DATA.printf("+++");
    while (a != 75) {
        if (DATA.readable()) {
            a = DATA.getc();
        }
    }
    wait(1);
    printf("Configuration Complete!\n");
    return 1;
}

int GetSerial(int *serial_no)
{
    int sh1,sh2,sh3,sl1,sl2,sl3,sl4;
    Serial DATA(_tx,_rx);
    wait_ms(50);
    DATA.printf("ATSL \r");
    DATA.scanf ("%2x%2x%2x%2x",&sl1,&sl2,&sl3,&sl4);
    wait_ms(500);
    DATA.printf("ATSH \r");
    DATA.scanf ("%2x%2x%2x",&sh1,&sh2,&sh3);
 
    serial_no[0] = sh1;
    serial_no[1] = sh2;
    serial_no[2] = sh3;
    serial_no[3] = sl1;
    serial_no[4] = sl2;
    serial_no[5] = sl3;
    serial_no[6] = sl4;
 
    return 1;
}

int SetKey(char* key)
{
    Serial DATA(_tx,_rx);
    DATA.printf("ATEE 0 \r");
 
    DATA.scanf ("%*s");
    wait_ms(1);
    DATA.printf("ATKY %s \r",key);
    DATA.scanf ("%*s");
    return 1;
}

int SetPanId(int pan_id)
{
    Serial DATA(_tx,_rx);
    wait_ms(5);
    DATA.printf("ATID %i\r",pan_id);
    DATA.scanf ("%*s");
    return 1;
}

int WriteSettings()
{
    Serial DATA(_tx,_rx);
    wait_ms(5);
    DATA.printf("ATWR \r");
    DATA.scanf ("%*s");
    return 1;
}

int ExitConfigMode()
{
    Serial DATA(_tx,_rx);
    wait_ms(5);
    DATA.printf("ATCN \r");
    DATA.scanf ("%*s");
    return 1;
}

void Reset()
{
    rst1 = 0;
    wait_ms(10);
    rst1 = 1;
    wait_ms(1);
}

int read_sentence(char* input){

    char tmp;
    while(!pc.readable());
    tmp = pc.getc();
    pc.putc(tmp);
    int counter = 0;
    while(tmp != '\n'){
        input[counter] = tmp;
        if(pc.readable()){
            tmp = pc.getc();
            pc.putc(tmp);
            counter++;
        } 
    }
    
    pc.printf("\n");
    return counter-1;
}

int read_xbee_sentence(char* input){
    char tmp;
    while(!xbee1.readable());
    tmp = xbee1.getc();
    int counter = 0;
    while(tmp != '\n'){
        input[counter] = tmp;
        if(xbee1.readable()){
            tmp = xbee1.getc();
            counter++;
        } 
    }
    return counter;
}

int main() {
    rst1 = 0; //Set reset pin to 0
    myled = 0;//Set LED3 to 0
    myled2= 0;//Set LED4 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond
    pc.printf("Student Machine\n");
    int device_serial[8];
    char security_key[] = {'h','e','l','l','o','m','o','b'};
    int pan_id = 5;
    ConfigMode();
    GetSerial(device_serial);
    SetKey(security_key);
    SetPanId(pan_id);
    WriteSettings();
    ExitConfigMode();
    Reset();
    char name[255];
    char id[255];
    pc.printf("Your Serial No: %d\n",device_serial);
    pc.printf("Please enter your name: \n");
    char_count = read_sentence(name);
    char set_name[char_count];
    for(int i = 0;i < char_count; i++){
      set_name[i] = name[i];    
    }
    pc.printf("Please enter your ID: \n");
    char_count = read_sentence(id);
    char set_id[char_count];
    for(int i = 0;i < char_count; i++){
      set_id[i] = id[i];    
    }
    pc.printf("Polling for available assessments!\n");
    string t;
    bool assessment_available = false;
    pc.printf("AA-\n");
    xbee1.printf("AA-\n");
    while(!assessment_available){
       wait(3);
       if(xbee1.readable()){
          char poll[30];
          read_xbee_sentence(poll);
          t = string(poll);
        }
        if(t.find("Available") != -1){
          assessment_available = true;   
        }else{
            xbee1.printf("AA-\n");
        }
    }
    pc.printf("A new assessment is available\n");
    pc.printf("Connecting to the Teacher Machine\n");
    pc.printf("%d\n",device_serial);
    pc.printf("C-%d\n",device_serial);
    xbee1.printf("C-%d\n",device_serial);
    wait(2);
    string serialKey = "";
    for(int j = 0; j < 8; j++){
      serialKey += device_serial[j];   
    }    
    while(true){
      if(xbee1.readable()){
         string input;
         char sentence_store[255];
         char_count = read_xbee_sentence(sentence_store);
         char set_sentence_store[char_count];
         for(int i = 0; i < char_count; i++){
            set_sentence_store[i] = sentence_store[i];   
         }        
         input = string(set_sentence_store);
         pc.printf("\n");
         if(input.find("NReq-") != -1){
            pc.printf("Name requested by the teacher machine. Sending your name in response\n");
            pc.printf("NRes-%d-%s\n",device_serial,set_name);
            xbee1.printf("NRes-%d-%s\n",device_serial,set_name);
         }else if(input.find("IDReq-" + string(set_name)) != -1){
            pc.printf("ID number has been requested by the teacher machine. Sending your ID number in response\n");
            pc.printf("IDRes-%d-%s",device_serial,set_id); 
            xbee1.printf("IDRes-%s\n",set_id);  
         }else if(input.find("QC-") != -1){
            int second_dash = input.find_last_of("-");
            string question_count = input.substr(second_dash+1,input.length()-1);
            int q_count = atoi (question_count.c_str());
            pc.printf("The # of questions in this assessment is %d\n",q_count);
            xbee1.printf("QA-\n");
            char answer_store[q_count];
            char c[10];
            pc.printf("Please enter your answers below\n\n");
            for(int i = 0; i < q_count; i++){
               pc.printf("Question %d - ",i+1);
               read_sentence(c);
               answer_store[i] = c[0];
            }
            xbee1.printf("ANS-%s\n",answer_store);
         }
         
       }   
    }
}