#include "wiflash.h"
#include "rtos.h"
#include <fstream>
#include <stdio.h>
#include <string>
#define IAP_LOCATION 0x1FFF1FF1
#define START_THREAD 1
extern "C" void mbed_reset();

Serial pc(USBTX,USBRX);
typedef void (*IAP)(unsigned long [], unsigned long[] );
IAP iap_entry = (IAP) IAP_LOCATION;
Mutex stdio_mutex; 
Thread *t;

void listdir(void) {
    DIR *d;
    struct dirent *p;
    string l;
    string full_file_name;
    string test1 = "_LPC1768.BIN";
    string test2 = "MBED.HTM";
    string test3 = "WIFLASH.TXT";
    d = opendir("/local");
    int ret;
    if (d != NULL) {
        while ((p = readdir(d)) != NULL) {
            l = string(p->d_name);
            
            if(l != test1 && l != test2 && l != test3){
               full_file_name = string("/local/") + l;
               ret = remove(full_file_name.c_str());
               if(ret == 0) 
               {
                  printf("File deleted successfully\n");
               }
               else 
               {
                  printf("Error: unable to delete the file\n");
               }   
            }
        }
    } else {
        printf("Could not open directory!\n");
    }
    closedir(d);
    mbed_reset();
}

Wiflash::Wiflash() : local("local"){
    
}

string get_serial_number(){
   unsigned long command[5] = {0,0,0,0,0};
    unsigned long result[5] = {0,0,0,0,0};
    command[0] = 58;  // read device serial number
    iap_entry(command, result);
    string output;
    stringstream out;
    if (result[0] == 0) {
        for(int i = 1; i < 5; i++) {
            out << result[i];
        }
    } else {
        printf("Status error!\r\n");
    }
    output = out.str();     
    return output;

}

 

void check_for_new_firmware(void const *args) {
     
    while (true) {
        TCPSocketConnection sock;
        sock.connect("104.236.198.189", 80); 
        stdio_mutex.lock();
        pc.printf("I am here\n");
        char url_buffer[100];
        pc.printf("I am here 2\n");
        sprintf (url_buffer, "GET /firmware_check/%s.json HTTP/1.0\n\n", get_serial_number().c_str());
        pc.printf(url_buffer);
        sock.send_all(url_buffer, sizeof(url_buffer)-1);
        char buffer[600];
        int ret;
        int total_chars = 0;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            if(ret == 25){
                pc.printf("Received the timestamp %s\n", buffer);
                pc.printf("%d\n",ret);
                FILE *ptr = fopen("/local/wiflash.txt", "r");
                char str[30];
                int i;
                i = fread(str, 1,30,ptr);
                str[i] = '\0';
                fclose(ptr);
                string response = string(buffer);
                string file_data = string(str);
                pc.printf("File timestamp %s\n",str);
                pc.printf("file data length %d\n",file_data.length());
                pc.printf("response data length %d\n",response.length());
                size_t found = response.find(file_data);
                if(file_data!= response){
                   ptr = fopen("/local/wiflash.txt", "w");
                   pc.printf("Received the timestamp %s\n", buffer);
                   fprintf(ptr,buffer);
                   fclose(ptr);
                   pc.printf("I am inside socket\n");
                   TCPSocketConnection sock2;
                   sock2.connect("104.236.198.189", 80);
                   char url2_buffer[100];
                   sprintf (url2_buffer, "GET /devices/%s/download.json HTTP/1.0\n\n", get_serial_number().c_str());
                   sock2.send_all(url2_buffer, sizeof(url_buffer)-1);
                   int ret2;
                   FILE* pFile;
                   pFile = fopen("/local/_LPC1768.bin", "wb");
                   int counter = 0;
                   char test[] = "\n\nHello\n\n";
                   memset( buffer, '\0', sizeof(char)*600 );
                   string k;
                   string phusion_passenger = "X-Powered-By: Phusion Passenger 5.0.6";
                   while (true) {
                      counter += 1;
                      ret2 = sock2.receive(buffer, sizeof(buffer)-1);
                      if (ret2 <= 0)
                            break;
                      buffer[ret2] = '\0';
                      k = string(buffer);
                      size_t found = k.find(phusion_passenger);
                      if (found == string::npos){
                        printf("Download data\n");
                        total_chars += ret2;
                        fwrite (buffer , sizeof(char), ret2, pFile);    
                      }
                      memset( buffer, '\0', sizeof(char)*600 );
                    }
                  fclose(pFile);
                  pc.printf("Total downloade chars %d\n",total_chars);
                  sock2.close();
                  listdir();
                  t->terminate();
                }
            }
        }   
        sock.close();
        wait(20);
        stdio_mutex.unlock();
    }
}



bool Wiflash::setUp(){
    int ret;
    stdio_mutex.lock();
    file = fopen("/local/wiflash.txt", "r");
    if(file){
        fclose(file);
    } else {
        file = fopen("/local/wiflash.txt", "w");
        fprintf(file, "Hello World!");
        fclose(file);
    }
    file = fopen("/local/_LPC1768.bin", "r");
    if(file){
        fclose(file);
    } else {
        file = fopen("/local/_LPC1768.bin", "w");
        fclose(file);
    }
    stdio_mutex.unlock();
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    t = new Thread(check_for_new_firmware);
    return true;
}