/* A simple library for interfacing with ESP8266 Wifi Module
   The API has been designed to very user friendly. The current
   version had to be developed in a very short amount of time. So
   its error handling capabilities are very limited. So please feel
   free to fork the project and contribute. 
   
   Copyright: Adhithya Rajasekaran
   Released Under: MIT License
*/

#include "mbed.h"
#include <string>
#include "MODSERIAL.h"

class ESP8266{
 private:  
   char *ssid;
   char *password;
   string ip;
   bool connection_successful;
   MODSERIAL *wifi;
   char* sendCmd(char* cmd);
   char* firmwareVersion();
   bool reset();
   void setMode(int modeVal);
   bool wiredCorrectly();
   bool joinAccessPoint(char *inputSSID, char *inputPassword);
   bool gotAnIPAddress();
   bool checkSSID(string inputSSID);
 public:
   ESP8266(MODSERIAL *input, char* inputSSID, char* inputPassword);
   bool checkConnection();
   string listAccessPoints();
   bool disconnect();
   string getMyIP();
};