#include "esp8266.h"
#include <algorithm>
#include <cctype>

// This file implements the methods described in the esp8266 header file
// Copyright: Adhithya Rajasekaran
// License: MIT License

/* General Note About ESP8266

   ESP8266 is controlled by using AT commands sent via Serial. Most of the API
   is implemented with AT commands. You can find the list of all AT commands at
   https://nurdspace.nl/ESP8266 

*/

ESP8266::ESP8266(MODSERIAL *input, char* inputSSID, char* inputPassword){
    /*
     Inputs:
         1. MODSERIAL* input - Pass in a reference to a MODSERIAL object. This MODSERIAL object should be connected to the
            ESP8266 module's pins 3 and 4. MODSERIAL is used instead of regular serial because it has buffering capability.
         2. char* inputSSID - Pass in a reference to a character array consisting of the SSID of the wireless network you
            want to connect to. Currently the library assumes that you are passing in the correct SSID and won't do any error
            checking. 
         3. char* inputPassword - Pass in a reference to a character array consisting of the password/shared key of the wireless network you
            want to connect to. Currently the library assumes that you are passing in the correct password and won't do any error
            checking. 
         
     TODO:
        1. Error checking of SSIDs by calling listOfAccessPoints() method and checking if the inputSSID is in the output of
           listOfAccessPoints() method. 
        2. Error checking of passwords by trying to actually connect the access point  
    */
    wifi = input;
    wifi->baud(115200); // This is the baud rate required to communicate the ESP8266 chip
    connection_successful = false;
    if(wiredCorrectly()){
      //connection_successful = true;
        if(joinAccessPoint(inputSSID,inputPassword)){
             getMyIP();
             string error = "ERROR";
             if(ip != error){
                connection_successful = true;      
             }   
        }
    }
}

string removeSpaces(string input)
{
  input.erase(std::remove(input.begin(),input.end(),'\r'),input.end());
  input.erase(std::remove(input.begin(),input.end(),'\n'),input.end());
  return input;
}

bool ESP8266::wiredCorrectly(){
    // This method checks if the ESP8266 module is wired correctly. 
    
    wifi->printf("AT\r\n");
    wait(2);
    char buf[20];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   //delete[] buf;
   printf("\n");
   size_t found = actual_output.find("OK");
   if (found!=std::string::npos){
     if(reset() == true){
       setMode(3);
       return true;  
     }else{
       return false;   
     }
   }else{
     return false;    
   }
}

bool ESP8266::reset(){
   // This method resets the settings inside the ESP8266 chip
   
    wifi->printf("AT+RST\r\n");
    wait(2);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   //delete[] buf;
   printf("\n");
   size_t found = actual_output.find("rst");
   if (found!=std::string::npos){
    return true;
   }else{
    return false;   
   }
}

char* ESP8266::firmwareVersion(){
    // Incomplete Method. Just use for firmware debugging purposes
    wifi->printf("AT+GMR\r\n");
    wait(2);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   //delete[] buf;
   printf("\n");
   const char* output = actual_output.c_str();
   return (char*) output;
}

void ESP8266::setMode(int val){
    // ESP8266 is set to mode 3 which will allow it to act
    // both as a client and server.
    wifi->printf("AT+CWMODE=3\r\n");
    wait(2);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   //delete[] buf;
   printf("\n");
}

bool ESP8266::checkConnection(){
    return connection_successful;   
}

bool ESP8266::gotAnIPAddress(){
    wifi->printf("AT+CIFSR\r\n");
    wait(2);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   //delete[] buf;
   printf("\n");
   size_t found = actual_output.find("ERROR");
   if (found!=std::string::npos){
    return false;
   }else{
    return true;   
   }
}


bool ESP8266::joinAccessPoint(char *inputSSID, char *inputPassword){
    // This method establishes connection with the requested access point
    // All authentication methods are supported (WEP, WPA)
    wifi->printf("AT+CWJAP=\"%s\",\"%s\"\r\n",inputSSID,inputPassword);
    wait(7);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   //delete[] buf;
   printf("\n");
   if(gotAnIPAddress() == true){
     return true;   
   }else{
     return false;   
   }
}

string ESP8266::getMyIP(){
    // Fetches the assigned IP address of the module
    wifi->printf("AT+CIFSR\r\n");
    wait(2);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(actual_output.c_str());
   string s = actual_output;
   //delete[] buf;
   s.erase( remove_if( s.begin(), s.end(),std::isspace ), s.end() );
   string ip_address = s.substr(8,s.length());
   string error = "ERROR";
   if(ip_address == error){
     ip = error;
   }else{
     ip = ip_address;
   }
   return ip;
}

bool ESP8266::checkSSID(string inputSSID){
    // This method checks the presence of the input SSID
    // with all the SSIDs that the ESP8266 chip detects
    wifi->printf("AT+CWLAP\r\n");
    wait(10);
    char buf[2000];
    int counter = 0;
    while(1){
     if(wifi->readable()){
        buf[counter] = wifi->getc();
        counter = counter + 1;
     }else{
        wait(2);
        if(!wifi->readable()){
          break;   
        }   
     }   
    }
   string test(buf);
   string actual_output = test.substr(0,counter);
   printf(inputSSID.c_str());
   printf(actual_output.c_str());
   wait(5);
   size_t found = actual_output.find(inputSSID);
   printf("I am here");
   if (found!=std::string::npos){
     return false;
   }else{
     return true;   
   }
   //delete[] buf;
}