#ifndef SPRITE_H
#define SPRITE_H

#include "mbed.h"
#include "Screen.h"


class Sprite: public Widget
{
public:
    /** Construct a Sprite
    *
    * @param mScreen the pointer screen
    * @param _id the identifier Id
    * @params _x the up left
    * @params _y the up left
    * @params _w the width
    * @params _h the height
    * @param _color the background color
    */
// constructor
    //
    Sprite(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _color);

    virtual ~Sprite();

    virtual void draw(void);

    //! test a overlap
    bool overlapWith(Sprite* pObj);
    //
    static bool overlap(Sprite* pObj1,Sprite* pObj2);
    //


//getter
    float getSpeedX(void) const;
    float getSpeedY(void) const;

//setter

    void setInvertSpeedX(void);
    void setInvertSpeedY(void);
    void setSpeedX(float _speedX);
    void setSpeedY(float _speedY);
    void setSpeedXY(float _speedX,float _speedY);

    void setUpdateAutomatic(bool _state);
    bool getUpdateAutomatic(void) const;

protected:
    void elementUpdate(void);

    bool myIsUpdateAutomatic;
    float mySpeedX,mySpeedY;

    UINT16 myXMoveMin,myXMoveMax,myYMoveMin,myYMoveMax;

};

#endif