#include "Sprite.h"

Sprite::Sprite(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _color):
    Widget(mScreen,_id,_x,_y,_w,_h,_color)
{

    myIsUpdateAutomatic=true;

    myXMoveMin=myScreen->getXpos();
    myYMoveMin=myScreen->getYpos();

    myXMoveMax=myXMoveMin+myScreen->getWidth();
    myYMoveMax= myYMoveMin+myScreen->getHeight();

    mySpeedX=0.0;
    mySpeedY=0.0;
}
//-------------------------------------
Sprite::~Sprite(void)
{
}

//-------------------------------------
void Sprite::setUpdateAutomatic(bool _state)
{
    myIsUpdateAutomatic=_state;
}
//---------------------------------------
bool Sprite::getUpdateAutomatic(void) const
{
    return this->myIsUpdateAutomatic;
}
//-------------------------------------
bool Sprite::overlapWith(Sprite* pObj)
{
    return overlap(this,pObj);
}
//-------------------------------------
bool Sprite::overlap(Sprite* pObj1,Sprite* pObj2)
{
    UINT16 x1=pObj1->getXposition();
    UINT16 x2=pObj2->getXposition();

    UINT16 y1=pObj1->getYposition();
    UINT16 y2=pObj2->getYposition();

    UINT16 xa=pObj1->getXposition()+pObj1->getWidth();
    UINT16 xb=pObj2->getXposition()+pObj2->getWidth();

    UINT16 ya=pObj1->getYposition()+pObj1->getHeight();
    UINT16 yb=pObj2->getYposition()+pObj2->getHeight();

    //
    if(x1 <xb && xa>x2 && y1<yb && ya>y2) {

        return true;
    } else {
        return false;
    }

}
//-------------------------------------
void Sprite::elementUpdate(void)
{
    switch(myState) {
            //
        case BUMP_DOWN:
            setInvertSpeedY();
            myState=STATE_ON;
            break;
            //
        case BUMP_LEFT:
            setInvertSpeedX();
            myState=STATE_ON;
            break;
            //
        case BUMP_RIGHT:
            setInvertSpeedX();
            myState=STATE_ON;
            break;
            //
        case BUMP_UP:
            setInvertSpeedY();
            myState=STATE_ON;
            break;
            //
        case STATE_OFF:
            break;
            //
        default:
            break;
    }
    //
}
//-------------------------------------
void Sprite::draw(void)
{
//to do
}
//----------------------------------------
float Sprite::getSpeedX(void) const
{
    return this->mySpeedX;
}
//----------------------------------------
float Sprite::getSpeedY(void) const
{
    return this->mySpeedY;
}
//----------------------------------------
void Sprite::setInvertSpeedX(void)
{
    mySpeedX=-(this->mySpeedX);
}
//----------------------------------------
void Sprite::setInvertSpeedY(void)
{
    mySpeedY=-(this->mySpeedY);
}
//----------------------------------------
void Sprite::setSpeedX(float _speedX)
{
    mySpeedX=_speedX;
}
//----------------------------------------
void Sprite::setSpeedY(float _speedY)
{
    mySpeedY=_speedY;
}
//----------------------------------------
void Sprite::setSpeedXY(float _speedX,float _speedY)
{
    mySpeedX=_speedX;
    mySpeedY=_speedY;
}


