#include "Screen.h"

Screen::Screen(PicasoSerial* serial,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _colorBkg):
    myXpos(_x),myYpos(_y),myWidth(_w),myHeight(_h),myColorBkg(_colorBkg)
{
    mySerial=serial;
}
//------------------------------------
Screen::~Screen(void)
{


    for(int i=0; i<myVectorObjet.size(); i++) {
        delete  myVectorObjet[i];
        myVectorObjet[i]=0;
    }
}
//------------------------------------
UINT16 Screen::getXpos(void) const
{
    return this->myXpos;
}
//----------------------------------
UINT16 Screen::getYpos(void) const
{
    return this->myYpos;
}
//------------------------------------
UINT16 Screen::getWidth(void) const
{
    return this->myWidth;
}
//-------------------------------------
UINT16 Screen::getHeight(void) const
{
    return this->myHeight;
}
//------------------------------------
void Screen::drawWidget(Widget* pObj)
{
    pObj->draw();

}
//------------------------------------
void Screen::drawAllWidget(void)
{
    mySerial->draw_filled_rectangle(myXpos,myYpos,myXpos+myWidth,myYpos+myHeight,myColorBkg);

    //
    for(int i=0; i<myVectorObjet.size(); i++) {
        drawWidget(myVectorObjet[i]);
    }
}
//-------------------------------------
void Screen::addWidget(Widget* pObj)
{
    myVectorObjet.push_back(pObj);
}
//---------------------------------------
PicasoSerial* Screen::getPicasoSerial(void) const
{
    return  mySerial;
}
//---------------------------------------
Color Screen::getColorBkg(void) const
{
    return myColorBkg;
}
//--------------------------------------
bool Screen::isContent(Widget* pObj, UINT16 _x,UINT16 _y)
{
    UINT16 xd=pObj->getXposition();
    UINT16 w=pObj->getWidth();
    UINT16 xf=xd+w;

    UINT16 yd=pObj->getYposition();
    UINT16 h=pObj->getHeight();
    UINT16 yf=yd+h;

    if(_x >= xd && _x<= xf && _y>=yd && _y<= yf) {
        return true;
    }

    return false;

}
//-------------------------------------
Widget* Screen::getWidgetPosition(UINT16 _x,UINT16 _y)
{

    if(myVectorObjet.size()==0)
        return NULL;

    //
    for(int i=0; i<myVectorObjet.size(); i++) {
        if(isContent(myVectorObjet[i],_x,_y))
            return myVectorObjet[i];
    }
    return NULL;
}
//-------------------------------------
Widget* Screen::getWidgetById(UINT16 _id)
{
    if(myVectorObjet.size()==0)
        return NULL;

    //
    for(int i=0; i<myVectorObjet.size(); i++) {
        if((myVectorObjet[i]->getId())== _id)
            return myVectorObjet[i];
    }
    return NULL;

}
//-------------------------------------
TouchEvent Screen::getTouchEvent(GraphicMessage* msg)
{
    TouchEvent ev=EVENT_NO_ACTIVITY;
    UINT16 xp=0;
    UINT16 yp=0;

    ev=mySerial->touch_get_status();

    //
    if(ev >EVENT_NO_ACTIVITY) {
        xp=mySerial->touch_get_x();
        yp=mySerial->touch_get_y();

        msg->event=ev;
        msg->posiX=xp;
        msg->posiY=yp;
        msg->objId=0;

        return ev;
    } else {

        msg->event=EVENT_NO_ACTIVITY;
        msg->posiX=0;
        msg->posiY=0;
        msg->objId=0;
    }
    //
    return ev;
}
//-------------------------------------
void Screen::getProcessMessage(GraphicMessage* msg)
{
    UINT16 xt=msg->posiX;
    UINT16 yt=msg->posiY;
    UINT16 res=0;

    Widget* obj=NULL;

    obj=getWidgetPosition(xt,yt);

    if(obj!=NULL && obj->getIsVisible()==true) {
        res=obj->getId();
        msg->objId=res;
    } else {
        msg->objId=0;
    }

}
//------------------------------------
void Screen::setClear()
{
   mySerial->draw_filled_rectangle(myXpos,myYpos,myXpos+myWidth,myYpos+myHeight,myColorBkg); 
}
///////////////////////////////////////

Widget::Widget(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _color):
    myScreen(mScreen),myId(_id),myX(_x),myY(_y),myWidth(_w),myHeight(_h),myColor(_color)
{

    myState=STATE_ON;
    myIsVisible=true;
}
//-------------------------------------
Widget::~Widget(void)
{
}
//-------------------------------------
//-------------------------------------
void Widget::draw(void)
{
//to do
}
//-------------------------------------
UINT16 Widget::getXposition(void) const
{
    return this->myX;
}
//---------------------------------------
UINT16 Widget::getYposition(void) const
{
    return this->myY;
}
//----------------------------------------
UINT16 Widget::getWidth(void) const
{
    return this->myWidth;
}
//----------------------------------------
UINT16 Widget::getHeight(void) const
{
    return this->myHeight;
}
//----------------------------------------
UINT16 Widget::getId(void) const
{
    return this->myId;
}
//----------------------------------------
WIDGET_TYPE Widget::getType(void) const
{
    return this->myType;
}
//----------------------------------------
bool Widget::getIsVisible(void) const
{
    return this->myIsVisible;
}
//----------------------------------------
Color Widget::getColor(void) const
{
    return myColor;
}
//----------------------------------------
void Widget::setVisibility(bool _val)
{
    (this->myIsVisible)=_val;
}
//----------------------------------------
State Widget::getState(void) const
{
    return this->myState;
}
//------------------------------------------
void Widget::setColor(Color _color)
{
    myColor=_color;
}
//------------------------------------------
void Widget::setState(State _state)
{
    myState=_state;
}
//------------------------------------------
void Widget::setId(UINT16 _id)
{
    myId=_id;
}
//------------------------------------------
void Widget::setXposition(UINT16 _xpos)
{
    this->myX=_xpos;
}
//------------------------------------------
void Widget::setYposition(UINT16 _ypos)
{
    this->myY=_ypos;
}
//----------------------------------------
 