#ifndef RECTANGLE_H
#define RECTANGLE_H

#include "Screen.h"
#include "Sprite.h"

class Rectangle:public Sprite
{
public:
    /** Construct a filled Rectangle
    *
    * @param mScreen the pointer screen
    * @param _id the identifier Id
    * @params _x the up left
    * @params _y the up left
    * @params _w the width
    * @params _h the height
    * @param _color the background color
    * @params _isVisible
    */
    Rectangle(Screen* mScreen,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _color);
    //
    virtual void draw(void);
    //
    virtual ~Rectangle(void);
    //
    //! updating the position of the object, in the case of a game
    void update(float delta);


//setter
    void setInvisible(bool _state);
    //
    void setNewPosition(INT16 _xcnew,INT16 _ycnew);
    //
    void setNewPosition(INT16 _xcnew,INT16 _ycnew,bool isScreenLimits);

};
   

#endif