#ifndef NUNCHUK_H
#define NUNCHUK_H

#include "mbed.h"

/** Class to interface with a Nintendo wii Nunchuk.
Exemple
@code
#include "mbed.h"
#include "Nunchuk.h"

Serial pc(USBTX,USBRX);
Nunchuk device(p28,p27,0.05);
int main()
{
while(1) {

 pc.printf("> :%d : %d : %d: %d \r\n",device.getJoyX(),device.getJoyY(),device.getAccX(),device.getBtnZ());

 wait(1);
        }
}
@endcode
 */

class Nunchuk
{

public:
    /** Construct a Nunchuk object.
        *
        * @param sda I2C channel to use.
        * @param scl I2C channel
        * @param mTe the sampling time for the internal Ticker
        * if @param mTe=0 start a new acquisition manually without internal Ticker
        */
    Nunchuk(PinName sda,PinName scl,float mTe=0);

    ~Nunchuk(void);

    /// start a new acquisition manually without internal Ticker
    void process(void);

    /// Get the joyStick position
    ///    @returns -1: joyStick in left position
    ///    @returns +1: joyStick in righ position
    ///    @returns 0: center position


    signed char getJoyX(void);

    //! Get the joyStick position
    //!   @returns -1: joyStick in left position
    //!   @returns +1: joyStick in righ position
    //!   @returns 0: center position

    signed char getJoyY(void);

    /** @returns The acceleration in axis X (10 bits)
    */
    int getAccX(void);

    /** @returns The acceleration in axis Y (10 bits)
    */
    int getAccY(void);

    /** @returns The acceleration in axis Z (10 bits)
    */
    int getAccZ(void);


    //! @returns true if button C pressed

    bool getBtnC(void);


    //! @returns true if button  Z pressed

    bool getBtnZ(void);

    /** @returns The sampling period
    */
    float getPeriodeTe(void);



protected:
    I2C myI2C;
    //
    Ticker myTicker;
    //
    bool setup(void);
    //
    bool request(void);
    //
    char decode(char data);
    //



//datas
    static const int ADRESSE=0xA4;
    signed char joyX;  //-1    0   +1
    signed char joyY;  //-1    0   +1

    int accX;
    int accY;
    int accZ;

    bool btnC;
    bool btnZ;

    float periodeTe;


};

#endif