#include "Nunchuk.h"

Nunchuk::Nunchuk(PinName sda,PinName scl,float mTe):myI2C(sda,scl)
{
    periodeTe=mTe;
    myI2C.frequency(100000);

    this->joyX=0x00;
    this->joyY=0x00;
    this->accX=0;
    this->accY=0;
    this->accZ=0;
    this->btnC=false;
    this->btnZ=false;

    setup();

    if(periodeTe>0)
        myTicker.attach(this,&Nunchuk::process,periodeTe);
}
//-----------------------
Nunchuk::~Nunchuk(void)
{
    if(periodeTe>0)
        myTicker.detach();
}
//-----------------------
void Nunchuk::process(void)
{
    bool res=false;
    static char datas[6];

    int i=0;

    res=request();  //demande une mesure
    if(res==false) {
        return ;   //pb
    }

    if(myI2C.read(ADRESSE,datas,6)==0) {
        res=true;

        for(i=0; i<6; i++) {
            datas[i]=decode(datas[i]);
        }

        //
        if(datas[0] < 100)
            joyX=-1;
        else if(datas[0] >200)
            joyX=1;
        else
            joyX=0;
        //
        if(datas[1] <100)
            joyY=-1;
        else if(datas[1] >140)
            joyY=1;
        else
            joyY=0;
        //
        accX=datas[2]<<2;
        accY=datas[3]<<2;
        accZ=datas[4]<<2;

        //btnZ
        if(datas[5] & 0x01)
            btnZ=false;
        else
            btnZ=true;


        //btnC
        if(datas[5]& 0x02)
            btnC=false;
        else
            btnC=true;

        accX+=(datas[5]>>2) & 0x0003;
        accY+=(datas[5]>>4) & 0x0003;
        accZ+=(datas[5]>>6) & 0x0003;


    } else {
        res=false;
        joyX=0;
        joyY=0;

        accX=0;
        accY=0;
        accZ=0;
        btnZ=false;
        btnC=false;
    }

}
//-----------------------
bool Nunchuk::setup(void)
{
    char cmd[2];
    bool res=false;

    cmd[0]=0x40;
    cmd[1]=0x00;

    if(myI2C.write(ADRESSE,cmd,2)==0) {
        res=true;
    } else {
        res=false;
    }
    return res;
}
//----------------------------
bool Nunchuk::request(void)
{
    bool res=false;
    char cmd[1]= {0x00};

    if(myI2C.write(ADRESSE,cmd,1)==0) {
        res=true;
        wait(0.001);

    } else {
        res=false;
    }

    return res;
}
//-----------------------------
float Nunchuk::getPeriodeTe(void)
{
    return periodeTe;
}
//-----------------------------
char Nunchuk::decode(char data)
{
    return (data^0x17)+0x17;
}
//------------------------------
signed char Nunchuk::getJoyX(void)
{
    return joyX;
}
//-------------------------------
signed char Nunchuk::getJoyY(void)
{
    return joyY;
}
//--------------------------------
int Nunchuk::getAccX(void)
{
    return accX;
}
//------------------------------
int Nunchuk::getAccY(void)
{
    return accY;
}
//----------------------------
int Nunchuk::getAccZ(void)
{
    return accZ;
}
//-----------------------------
bool Nunchuk::getBtnC(void)
{
    return btnC;
}
//-------------------------------
bool Nunchuk::getBtnZ(void)
{
    return btnZ;
}