#ifndef KEYBOARD_H
#define KEYBOARD_H

#include "mbed.h"
#include "Screen.h"
#include "Button.h"
#include "Label.h"
#include "PicasoSerial.h"
#include "Nunchuk.h"
#include "Buzzer.h"
#include <string>

#define BTN_0_ID    10
#define BTN_1_ID    11
#define BTN_2_ID    12
#define BTN_3_ID    13
#define BTN_4_ID    14
#define BTN_5_ID    15
#define BTN_6_ID    16
#define BTN_7_ID    17
#define BTN_8_ID    18
#define BTN_9_ID    19

#define BTN_A_ID    100
#define BTN_B_ID    101
#define BTN_C_ID    102
#define BTN_D_ID    103
#define BTN_E_ID    104
#define BTN_F_ID    105
#define BTN_G_ID    106
#define BTN_H_ID    107
#define BTN_I_ID    108
#define BTN_J_ID    109
#define BTN_K_ID    110
#define BTN_L_ID    111
#define BTN_M_ID    112
#define BTN_N_ID    113
#define BTN_O_ID    114
#define BTN_P_ID    115
#define BTN_Q_ID    116
#define BTN_R_ID    117
#define BTN_S_ID    118
#define BTN_T_ID    119
#define BTN_U_ID    120
#define BTN_V_ID    121
#define BTN_W_ID    122
#define BTN_X_ID    123
#define BTN_Y_ID    124
#define BTN_Z_ID    125

#define BTN_ESP_ID  200
#define BTN_DEL_ID  201
#define BTN_OK_ID   202
#define BTN_POINT_ID    203


class Keyboard
{
public:
    Keyboard(Screen* pscreen,string titre="Keyboard",Nunchuk* pnunchuk=NULL,Buzzer* pbuzzer=NULL,
             float sampleTime=0.1);

    Keyboard(Screen* pscreen,string titre="Keyboard",Buzzer* pbuzzer=NULL);

    virtual ~Keyboard(void);

    bool isEnterPressed(void);

    void draw(void);

    //int getString(char* str);

    string getString(void);

private:
    Screen* myScreen;
    string myTitre;
    Buzzer* myBuzzer;
    Nunchuk* myNunchuk;

    float mySampleTime;

    GraphicMessage myMessage;

    Ticker myTicker;

    void loop(void);

    char myBuffer[50];
    string myString;

    bool myEnter;
    int myIndice;
    int myPointeur;

    Note* myBeep;

    void createScreen(void);
    void affiche(void);

    void initialisation(void);
    void actionNunchuk(void);
    void afficheById(UINT16 id);

    Label* pLabelTitre;
    Label* pLabel;

    Button* pBtn_0;
    Button* pBtn_1;
    Button* pBtn_2;
    Button* pBtn_3;
    Button* pBtn_4;
    Button* pBtn_5;
    Button* pBtn_6;
    Button* pBtn_7;
    Button* pBtn_8;
    Button* pBtn_9;

    Button* pBtn_A;
    Button* pBtn_B;
    Button* pBtn_C;
    Button* pBtn_D;
    Button* pBtn_E;
    Button* pBtn_F;
    Button* pBtn_G;
    Button* pBtn_H;
    Button* pBtn_I;
    Button* pBtn_J;

    Button* pBtn_K;
    Button* pBtn_L;
    Button* pBtn_M;
    Button* pBtn_N;
    Button* pBtn_O;
    Button* pBtn_P;
    Button* pBtn_Q;
    Button* pBtn_R;
    Button* pBtn_S;
    Button* pBtn_T;
    Button* pBtn_U;

    Button* pBtn_V;
    Button* pBtn_W;
    Button* pBtn_X;
    Button* pBtn_Y;
    Button* pBtn_Z;

    Button* pBtn_Point;

    Button* pBtn_Esp;
    Button* pBtn_Del;
    Button* pBtn_Ok;

    Button* myTabBtn[40];
};

#endif