#include "Keyboard.h"

//
Keyboard::Keyboard(Screen* pscreen,string titre,Nunchuk* pnunchuk,Buzzer* pbuzzer,float sampleTime):myScreen(pscreen),myTitre(titre),
    myBuzzer(pbuzzer),myNunchuk(pnunchuk),mySampleTime(sampleTime)
{
    myBeep= new Note("F%4",50);
    myEnter=false;

    myIndice=0;
    myPointeur=0;

    initialisation();

    createScreen();
}
//------------------------------------------------
Keyboard::Keyboard(Screen* pscreen,string titre,Buzzer* pbuzzer):myScreen(pscreen),myTitre(titre),myBuzzer(pbuzzer)
{
    myNunchuk=NULL;
    mySampleTime=0.1;

    myBeep= new Note("F%4",50);
    myEnter=false;

    myIndice=0;
    myPointeur=0;

    initialisation();

    createScreen();
}
//------------------------------------------------
void Keyboard::initialisation(void)
{
    myMessage.event=EVENT_NO_ACTIVITY;
    myMessage.objId=0;
    myMessage.posiX=0;
    myMessage.posiY=0;

    for(int i=0; i<50; i++) {
        myBuffer[i]='\0';
    }
    //
    for(int i=0; i<40; i++) {
        myTabBtn[i]=0;
    }
    myString="";

    pLabelTitre=0;
    pLabel=0;

    pBtn_0=0;
    pBtn_1=0;
    pBtn_2=0;
    pBtn_3=0;
    pBtn_4=0;
    pBtn_5=0;
    pBtn_6=0;
    pBtn_7=0;
    pBtn_8=0;
    pBtn_9=0;

    pBtn_A=0;
    pBtn_B=0;
    pBtn_C=0;
    pBtn_D=0;
    pBtn_E=0;
    pBtn_F=0;
    pBtn_G=0;
    pBtn_H=0;
    pBtn_I=0;
    pBtn_J=0;

    pBtn_K=0;
    pBtn_L=0;
    pBtn_M=0;
    pBtn_N=0;
    pBtn_O=0;
    pBtn_P=0;
    pBtn_Q=0;
    pBtn_R=0;
    pBtn_S=0;
    pBtn_T=0;
    pBtn_U=0;

    pBtn_V=0;
    pBtn_W=0;
    pBtn_X=0;
    pBtn_Y=0;
    pBtn_Z=0;

    pBtn_Point=0;

    pBtn_Esp=0;
    pBtn_Del=0;
    pBtn_Ok=0;
}
//------------------------------------------------
Keyboard::~Keyboard(void)
{
    myTicker.detach();

    if(myScreen!=NULL)
        delete myScreen;

    if(myBeep!=NULL)
        delete myBeep;

}
//------------------------------------------------
bool Keyboard::isEnterPressed(void)
{
    return myEnter;
}
//------------------------------------------------
void Keyboard::loop(void)
{

    if(myNunchuk==NULL) {

        TouchEvent event=myScreen->getTouchEvent(&myMessage);//EVENT_NO_ACTIVITY EVENT_PRESS EVENT_RELEASE EVENT_MOVE

        if(event>0) {
            myScreen->getProcessMessage(&myMessage);
            affiche();

        }
    }
    //
    else {
        myNunchuk->process();
        actionNunchuk();
    }

}
//------------------------------------------------
void Keyboard::draw(void)
{
    myScreen->drawAllWidget();

    wait(0.1);

    myTicker.attach(this,&Keyboard::loop,mySampleTime);
}
//------------------------------------------------
//int Keyboard::getString(char* str)
string  Keyboard::getString(void)
{
    myString="";

    for(int i=0; i<myIndice; i++) {
        myString+=myBuffer[i];
    }

    return myString;
    /*
    for(int i=0; i<myIndice; i++) {
        str[i]=myBuffer[i];
    }

    return myIndice;
    */
}

//-------------------------------------------------
void Keyboard::createScreen(void)
{
    UINT16 w=22;
    UINT16 h=25;

    UINT16 sx=5;
    UINT16 sy=150;

    myPointeur=0;

    //---------------------
    pLabelTitre= new Label(myScreen,5,5,myTitre,FONT_3,BLACK,YELLOW);
    //---------------------
    pLabel= new Label(myScreen,5,40,"_",FONT_3,BLACK,YELLOW);

    //
    pBtn_0= new Button(myScreen,BTN_0_ID,sx,sy,"0",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_0;
    myPointeur++;
    sx+=w;
    //
    pBtn_1= new Button(myScreen,BTN_1_ID,sx,sy,"1",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_1;
    myPointeur++;
    sx+=w;

    pBtn_2= new Button(myScreen,BTN_2_ID,sx,sy,"2",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_2;
    myPointeur++;
    sx+=w;

    pBtn_3= new Button(myScreen,BTN_3_ID,sx,sy,"3",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_3;
    myPointeur++;
    sx+=w;

    pBtn_4= new Button(myScreen,BTN_4_ID,sx,sy,"4",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_4;
    myPointeur++;
    sx+=w;

    pBtn_5= new Button(myScreen,BTN_5_ID,sx,sy,"5",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_5;
    myPointeur++;
    sx+=w;

    pBtn_6= new Button(myScreen,BTN_6_ID,sx,sy,"6",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_6;
    myPointeur++;
    sx+=w;

    pBtn_7= new Button(myScreen,BTN_7_ID,sx,sy,"7",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_7;
    myPointeur++;
    sx+=w;

    pBtn_8= new Button(myScreen,BTN_8_ID,sx,sy,"8",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_8;
    myPointeur++;
    sx+=w;

    pBtn_9= new Button(myScreen,BTN_9_ID,sx,sy,"9",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_9;
    myPointeur++;

    //----
    sx=5;
    sy+=h+5;
    pBtn_A= new Button(myScreen,BTN_A_ID,sx,sy,"A",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_A;
    myPointeur++;
    sx+=w;

    pBtn_Z= new Button(myScreen,BTN_Z_ID,sx,sy,"Z",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Z;
    myPointeur++;
    sx+=w;

    pBtn_E= new Button(myScreen,BTN_E_ID,sx,sy,"E",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_E;
    myPointeur++;
    sx+=w;

    pBtn_R= new Button(myScreen,BTN_R_ID,sx,sy,"R",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_R;
    myPointeur++;
    sx+=w;

    pBtn_T= new Button(myScreen,BTN_T_ID,sx,sy,"T",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_T;
    myPointeur++;
    sx+=w;

    pBtn_Y= new Button(myScreen,BTN_Y_ID,sx,sy,"Y",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Y;
    myPointeur++;
    sx+=w;

    pBtn_U= new Button(myScreen,BTN_U_ID,sx,sy,"U",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_U;
    myPointeur++;
    sx+=w;

    pBtn_I= new Button(myScreen,BTN_I_ID,sx,sy,"I",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_I;
    myPointeur++;
    sx+=w;

    pBtn_O= new Button(myScreen,BTN_O_ID,sx,sy,"O",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_O;
    myPointeur++;
    sx+=w;

    pBtn_P= new Button(myScreen,BTN_P_ID,sx,sy,"P",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_P;
    myPointeur++;
    //------------------------------
    sx=5;
    sy+=h;

    sx+=w/2;
    pBtn_Q= new Button(myScreen,BTN_Q_ID,sx,sy,"Q",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Q;
    myPointeur++;
    sx+=w;

    pBtn_S= new Button(myScreen,BTN_S_ID,sx,sy,"S",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_S;
    myPointeur++;
    sx+=w;

    pBtn_D= new Button(myScreen,BTN_D_ID,sx,sy,"D",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_D;
    myPointeur++;
    sx+=w;

    pBtn_F= new Button(myScreen,BTN_F_ID,sx,sy,"F",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_F;
    myPointeur++;
    sx+=w;

    pBtn_G= new Button(myScreen,BTN_G_ID,sx,sy,"G",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_G;
    myPointeur++;
    sx+=w;

    pBtn_H= new Button(myScreen,BTN_H_ID,sx,sy,"H",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_H;
    myPointeur++;
    sx+=w;

    pBtn_J= new Button(myScreen,BTN_J_ID,sx,sy,"J",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_J;
    myPointeur++;
    sx+=w;

    pBtn_K= new Button(myScreen,BTN_K_ID,sx,sy,"K",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_K;
    myPointeur++;
    sx+=w;

    pBtn_L= new Button(myScreen,BTN_L_ID,sx,sy,"L",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_L;
    myPointeur++;
    //----------------
    sx=5;
    sy+=h;

    sx+=w;

    pBtn_W= new Button(myScreen,BTN_W_ID,sx,sy,"W",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_W;
    myPointeur++;
    sx+=w;

    pBtn_X= new Button(myScreen,BTN_X_ID,sx,sy,"X",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_X;
    myPointeur++;
    sx+=w;

    pBtn_C= new Button(myScreen,BTN_C_ID,sx,sy,"C",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_C;
    myPointeur++;
    sx+=w;

    pBtn_V= new Button(myScreen,BTN_V_ID,sx,sy,"V",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_V;
    myPointeur++;
    sx+=w;

    pBtn_B= new Button(myScreen,BTN_B_ID,sx,sy,"B",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_B;
    myPointeur++;
    sx+=w;

    pBtn_N= new Button(myScreen,BTN_N_ID,sx,sy,"N",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_N;
    myPointeur++;
    sx+=w;

    pBtn_M= new Button(myScreen,BTN_M_ID,sx,sy,"M",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_M;
    myPointeur++;
    sx+=w;

    pBtn_Point=new Button(myScreen,BTN_POINT_ID,sx,sy,".",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Point;
    myPointeur++;
    //-------------------
    sx=5;
    sy+=h+5;

    pBtn_Del=new Button(myScreen,BTN_DEL_ID,sx,sy,"Suppr",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Del;
    myPointeur++;
    sx+=3*w;

    pBtn_Esp= new Button(myScreen,BTN_ESP_ID,sx,sy," Espace ",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Esp;
    myPointeur++;
    sx+=4*w;

    pBtn_Ok=new Button(myScreen,BTN_OK_ID,sx,sy,"Enter",FONT_3,BLACK,GRAY,BUTTON_STATE_PRESSED);
    myTabBtn[myPointeur]=pBtn_Ok;

    //
    myPointeur=10;

}
//--------------------------------------------------
void Keyboard::affiche(void)
{
    UINT16 id=myMessage.objId;

    static Button* pb=NULL;

    if(myMessage.event==EVENT_PRESS && id>0) {
        if(myBuzzer!=NULL)
            myBuzzer->tone(myBeep);

        pb=(Button*)myScreen->getWidgetById(id);

        if(pb!=NULL) {
            pb->setState(BUTTON_STATE_RELEASED);
            wait(0.1);
            pb->setState(BUTTON_STATE_PRESSED);
        }

        if(myIndice >50 || myIndice<0)
            myIndice=0;

        //
        afficheById(id);

    }
}
//--------------------------------------------------
void Keyboard::afficheById(UINT16 id)
{
    char str='_';

//les nombres
    if(id>=10 && id<20) {
        str='0'+(id-10);

        myBuffer[myIndice]=str;
        myIndice++;

        myBuffer[myIndice]='_';
        //pLabel->setNewText(myBuffer,myIndice-1);
        pLabel->setNewText(myBuffer);
        return;

    }
//
//les lettres
    if(id>=100 && id<126) {
        str='A'+(id-100);

        myBuffer[myIndice]=str;
        myIndice++;

        myBuffer[myIndice]='_';
        //pLabel->setNewText(myBuffer,myIndice-1);
        pLabel->setNewText(myBuffer);
        return;
    }
//
//le point
    if(id==BTN_POINT_ID) {
        str='.';
        myBuffer[myIndice]=str;
        myIndice++;

        myBuffer[myIndice]='_';
        // pLabel->setNewText(myBuffer,myIndice-1);
        pLabel->setNewText(myBuffer);

        return;
    }
//
//l'espace
    if(id==BTN_ESP_ID) {
        str=' ';

        myBuffer[myIndice]=str;
        myIndice++;

        myBuffer[myIndice]='_';
        // pLabel->setNewText(myBuffer,myIndice-1);
        pLabel->setNewText(myBuffer);
        return;
    }
//
//enter
    if(id==BTN_OK_ID) {
        myEnter=true;
        return;
    }

//Supp
    if(id==BTN_DEL_ID) {
        if(myIndice>=0)
            myIndice--;

        myBuffer[myIndice]='_';
        //pLabel->setNewText(myBuffer,myIndice-1);
        pLabel->setNewText(myBuffer);
    }
}

//--------------------------------------------------
void Keyboard::actionNunchuk(void)
{

    static bool isZ=false;
    static Button* pb=myTabBtn[10];


    signed char posX=myNunchuk->getJoyX();

    signed char valZ=myNunchuk->getBtnZ();

    signed char valC=myNunchuk->getBtnC();


    //
    switch(valC) {
        case 1:
            myEnter=true;
            return;
            //
        case 0:
            myEnter=false;
            break;
    }
    //
    ////////////////////////
    switch(valZ) {
        case 1:
            if(isZ==false) {
                if(myPointeur==39) {
                    myEnter=true;
                    return;
                }

                pb=myTabBtn[myPointeur];

                UINT16 id=pb->getId();

                afficheById(id);


                isZ=true;
            }
            break;

            //
        case 0:
            isZ=false;
            break;

            //
        default:
            break;
    }
    //


    //
    switch(posX) {
        case -1:
            myPointeur--;
            if(myPointeur<0)
                myPointeur=39;

            pb=myTabBtn[myPointeur];

            if(pb!=NULL) {
                pb->setState(BUTTON_STATE_RELEASED);
                wait(0.1);
                pb->setState(BUTTON_STATE_PRESSED);
            }

            break;

            //
        case 1:
            myPointeur++;

            if(myPointeur>39)
                myPointeur=0;

            pb=myTabBtn[myPointeur];

            if(pb!=NULL) {
                pb->setState(BUTTON_STATE_RELEASED);
                wait(0.1);
                pb->setState(BUTTON_STATE_PRESSED);
            }

            break;

            //
        case 0:

            if(pb!=NULL ) {
                pb->setState(BUTTON_STATE_RELEASED);
                wait(0.1);
                pb->setState(BUTTON_STATE_PRESSED);
                wait(0.1);
            }
            break;

            //
        default:
            break;
    }

    //
}
//--------------------------------------------------