#ifndef DIGIT_LED_H
#define DIGIT_LED_H

#include "Screen.h"

class DigitLed:public Widget
{
public:
    /** Construct a Digit Led
        *
        * @param mScreen the pointer screen
        * @params _x up left
        * @params _y up left
        * @params _ptVisible
        */
    DigitLed(Screen* mScreen,UINT16 _x,UINT16 _y,bool _ptVisible);
    //
    virtual void draw(void);
    //
    virtual ~DigitLed(void);
    //
    void setInvisible(bool _state);
    //
    void setValue(char _value);
    //
    void setColorBkg(Color _colorBkg);
    //
    void setColorSeg(Color _colorSeg);
    //
    void setPtVisible(bool _state);

protected:
    char myValue;
    Color myColorBkg;
    Color myColorSeg;
    UINT16 myIncX;
    UINT16 myIncY;
    bool isPtVisible;
    //
    void draw_seg_a(PicasoSerial* ps);
    void draw_seg_b(PicasoSerial* ps);

    void draw_seg_c(PicasoSerial* ps);

    void draw_seg_d(PicasoSerial* ps);
    void draw_seg_e(PicasoSerial* ps);
    void draw_seg_f(PicasoSerial* ps);

    void draw_seg_g(PicasoSerial* ps);
    void draw_seg_pt(PicasoSerial* ps);
};

#endif