#include "DigitLed.h"

DigitLed::DigitLed(Screen* mScreen,UINT16 _x,UINT16 _y,bool _ptVisible):
    Widget(mScreen,0,_x,_y,36,52,WHITE)
{
    myValue=0;
    myColorBkg=YELLOW;
    myColorSeg=RED;
    myIncX=4;
    myIncY=4;

    isPtVisible=_ptVisible;

    myType=OBJ_DIGIT_LED;
    myState=DIGIT_LED_STATE_ON;

    myScreen->addWidget((Widget*) this);
}
//-----------------------------------------
DigitLed::~DigitLed(void)
{
}
//-----------------------------------------
void DigitLed::setColorBkg(Color _colorBkg)
{
    if(myColorBkg==_colorBkg)
        return;

    myColorBkg=_colorBkg;
    this->draw();
}
//------------------------------------------
void DigitLed::setColorSeg(Color _colorSeg)
{
    if(myColorSeg==_colorSeg)
        return;

    myColorSeg=_colorSeg;
    this->draw();
}
//-----------------------------------------
void DigitLed::draw(void)
{
    if(myIsVisible==false)
        return;
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    //rec
    if(ps!=0) {
        ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,myColorBkg);
    }

    if(isPtVisible)
        draw_seg_pt(ps);

    //
    switch(myValue) {
        case 0:
            draw_seg_a(ps);
            draw_seg_b(ps);
            draw_seg_c(ps);
            draw_seg_d(ps);
            draw_seg_e(ps);
            draw_seg_f(ps);
            break;
            //
        case 1:
            draw_seg_b(ps);
            draw_seg_c(ps);
            break;
            //
        case 2:
            draw_seg_a(ps);
            draw_seg_b(ps);
            draw_seg_d(ps);
            draw_seg_e(ps);
            draw_seg_g(ps);
            break;
            //
        case 3:
            draw_seg_a(ps);
            draw_seg_b(ps);
            draw_seg_c(ps);
            draw_seg_d(ps);
            draw_seg_g(ps);
            break;
            //
        case 4:
            draw_seg_b(ps);
            draw_seg_c(ps);
            draw_seg_f(ps);
            draw_seg_g(ps);
            break;
            //
        case 5:
            draw_seg_a(ps);
            draw_seg_c(ps);
            draw_seg_d(ps);
            draw_seg_f(ps);
            draw_seg_g(ps);
            break;
            //
        case 6:
            draw_seg_a(ps);
            draw_seg_c(ps);
            draw_seg_d(ps);
            draw_seg_e(ps);
            draw_seg_f(ps);
            draw_seg_g(ps);
            break;
            //
        case 7:
            draw_seg_a(ps);
            draw_seg_b(ps);
            draw_seg_c(ps);
            break;
            //
        case 8:
            draw_seg_a(ps);
            draw_seg_b(ps);
            draw_seg_c(ps);
            draw_seg_d(ps);
            draw_seg_e(ps);
            draw_seg_f(ps);
            draw_seg_g(ps);
            break;
            //
        case 9:
            draw_seg_a(ps);
            draw_seg_b(ps);
            draw_seg_c(ps);
            draw_seg_d(ps);
            draw_seg_f(ps);
            draw_seg_g(ps);
            break;
    }
    ps=0;
}
//-----------------------------------------
void DigitLed::setValue(char _value)
{
    if(myIsVisible==false)
        return;

    if(myValue==_value)
        return;


    if(_value >9)
        _value=9;

    myValue=_value;

    this->draw();
}
//-----------------------------------------
void DigitLed::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//-----------------------------------------
void DigitLed::setPtVisible(bool _state)
{
    if(isPtVisible==_state)
        return;

    isPtVisible=_state;
}
//-----------------------------------------
void DigitLed::draw_seg_a(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myIncX,
                                  myY,
                                  myX+7*myIncX,
                                  myY+myIncY,
                                  myColorSeg);
}
//------------------------------------------
void DigitLed::draw_seg_b(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+6*myIncX,
                                  myY,
                                  myX+7*myIncX,
                                  myY+5*myIncY,
                                  myColorSeg);
}
//-------------------------------------------
void DigitLed::draw_seg_c(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+6*myIncX,
                                  myY+8*myIncY,
                                  myX+7*myIncX,
                                  myY+myHeight,
                                  myColorSeg);
}
//--------------------------------------------
void DigitLed::draw_seg_d(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myIncX,
                                  myY+myHeight-myIncY,
                                  myX+7*myIncX,
                                  myY+myHeight,
                                  myColorSeg);
}
//-----------------------------------------
void DigitLed::draw_seg_e(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myIncX,
                                  myY+myHeight-5*myIncY,
                                  myX+2*myIncX,
                                  myY+myHeight,
                                  myColorSeg);
}
//-----------------------------------------
void DigitLed::draw_seg_f(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myIncX,
                                  myY,
                                  myX+2*myIncX,
                                  myY+5*myIncY,
                                  myColorSeg);
}
//------------------------------------------
void DigitLed::draw_seg_g(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myIncX,
                                  myY+6*myIncY,
                                  myX+7*myIncX,
                                  myY+7*myIncY,
                                  myColorSeg);
}
//------------------------------------------
void DigitLed::draw_seg_pt(PicasoSerial* ps)
{
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myWidth-myIncX,
                                  myY+myHeight-myIncY,
                                  myX+myWidth,
                                  myY+myHeight,
                                  myColorSeg);
}