#include "Digit3Led.h"

Digit3Led::Digit3Led(Screen* mScreen,UINT16 _x,UINT16 _y,UINT8 _resolution):
    Widget(mScreen,0,_x,_y,108,52,YELLOW)
{
    myColorBkg=YELLOW;
    myColorSeg=RED;
    myValue=0.0;
    myResolution=_resolution;

    myDigitLedCentaine= new DigitLed(mScreen,_x,_y,false);
    myDigitLedDizaine=new DigitLed(mScreen,_x+36,_y,false);
    myDigitLedUnite= new DigitLed(mScreen,_x+36+36,_y,false);


    myType= OBJ_DIGITAL_3_LED;
    myState=DIGIT_LED_STATE_ON;

    myScreen->addWidget((Widget*) this);
}
//------------------------------------------
Digit3Led::~Digit3Led(void)
{
    delete(myDigitLedCentaine);
    myDigitLedCentaine=0;
    delete(myDigitLedDizaine);
    myDigitLedDizaine=0;
    delete(myDigitLedUnite);
    myDigitLedUnite=0;
}
//------------------------------------------
void Digit3Led::draw(void)
{
    if(myIsVisible==false)
        return;

    myDigitLedCentaine->draw();
    myDigitLedDizaine->draw();
    myDigitLedUnite->draw();

}
//------------------------------------------
void Digit3Led::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();
        PicasoSerial* ps=0;

        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//-----------------------------------------
void Digit3Led::setValue(float _value)
{
    if(myIsVisible==false)
        return;
    //
    if(myValue==_value)
        return;
    //
    myValue=_value;
    UINT16 temp=0;

    char centaine=0;
    char dizaine=0;
    char unite=0;

    //the Pt?
    switch(myResolution) {
        case 1:     //xxx
            temp=(UINT16)_value;
            myDigitLedCentaine->setPtVisible(false);
            myDigitLedDizaine->setPtVisible(false);
            myDigitLedUnite->setPtVisible(false);
            break;
            //
        case 10:    //xx.x
            temp=(UINT16)(_value*10);
            myDigitLedCentaine->setPtVisible(false);
            myDigitLedDizaine->setPtVisible(true);
            myDigitLedUnite->setPtVisible(false);
            break;
            //
        case 100:   //x.xx
            temp=(UINT16)(_value*100);
            myDigitLedCentaine->setPtVisible(true);
            myDigitLedDizaine->setPtVisible(false);
            myDigitLedUnite->setPtVisible(false);
            break;

        default:
            break;
    }
    //
    if(temp <100) {
        centaine=0;
        myDigitLedCentaine->setInvisible(true);
    } else {
        myDigitLedCentaine->setInvisible(false);
        centaine=(char)(temp/100);
        temp=temp-(centaine*100);
    }
    //
    if(temp <10) {
        dizaine=0;
    } else {
        dizaine=(char)(temp/10);
        temp=temp-(dizaine*10);
    }
    //
    unite=(char)temp;

    myDigitLedCentaine->setValue(centaine);
    myDigitLedDizaine->setValue(dizaine);
    myDigitLedUnite->setValue(unite);

    this->draw();
}
//------------------------------------------
void Digit3Led::setColorBkg(Color _colorBkg)
{
    if(myColorBkg==_colorBkg)
        return;

    myColorBkg=_colorBkg;
    myDigitLedCentaine->setColorBkg(_colorBkg);
    myDigitLedDizaine->setColorBkg(_colorBkg);
    myDigitLedUnite->setColorBkg(_colorBkg);

    this->draw();
}
//------------------------------------------
void Digit3Led::setColorSeg(Color _colorSeg)
{
    if(myColorSeg==_colorSeg)
        return;

    myColorSeg=_colorSeg;
    myDigitLedCentaine->setColorSeg(_colorSeg);
    myDigitLedDizaine->setColorSeg(_colorSeg);
    myDigitLedUnite->setColorSeg(_colorSeg);

    this->draw();
}