#include "Diamond.h"

Diamond::Diamond(Screen* mScreen,UINT16 x1,UINT16 y1,UINT16 x2,UINT16 y2,
                 UINT16 x3,UINT16 y3,UINT16 x4,UINT16 y4,Color _color):

    Sprite(mScreen,0,x1,y4,x3-x1,y2-y4,_color)
{
    myX1=x1;
    myY1=y1;

    myX2=x2;
    myY2=y2;

    myX3=x3;
    myY3=y3;

    myX4=x4;
    myY4=y4;

    myU1=x4-x1;
    myU2=x2-x1;

    myV1=y1-y4;
    myV2=y3-y4;


    myType=OBJ_DIAMOND;

    myScreen->addWidget((Widget*) this);
}
//-----------------------------------------
void Diamond::draw(void)
{
    // isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_filled_diamond(myX1,myY1,myX2,myY2,myX3,myY3,myX4,myY4,myColor);
    }
    ps=0;
}
//-----------------------------------------
Diamond::~Diamond(void)
{
}
//----------------------------
void Diamond::update(float delta)
{
    if(myIsUpdateAutomatic)
        elementUpdate();
    //
    float xnew=myX+mySpeedX*delta;
    float ynew=myY+mySpeedY*delta;

    this->setNewPosition((INT16)xnew,(INT16)ynew,true);
}
//-------------------------------
void Diamond::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_diamond(myX1,myY1,myX2,myY2,myX3,myY3,myX4,myY4,c);
            
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;

        this->draw();
    }
}
//--------------------------------
void Diamond::setNewPosition(INT16 _xnew,INT16 _ynew)
{
   setNewPosition(_xnew,_ynew,true);
}
//---------------------------------
void Diamond::setNewPosition(INT16 _xnew,INT16 _ynew,bool isScreenLimits)
{
    if(myIsVisible==false)
        return;
    //
    if(myX==_xnew && myY==_ynew)
        return;
    setInvisible(true); // colorie le tri avec couleur de la screen

    myIsVisible=true;

if(isScreenLimits)
{
    //test Xmax
    if(_xnew+myWidth >= myXMoveMax) {
        _xnew=myXMoveMax-myWidth;

        if(myState==STATE_ON)
            myState=BUMP_RIGHT;
    }
    //
    //test Xmin
    if(_xnew <= myXMoveMin) {
        _xnew=myXMoveMin;

        if(myState==STATE_ON)
            myState=BUMP_LEFT;
    }
    //test Ymax
    if(_ynew +myHeight >= myYMoveMax && _ynew >0) {
        _ynew = myYMoveMax- myHeight;

        if(myState==STATE_ON)
            myState=BUMP_DOWN;
    }
    //test yminMin;
    if(_ynew <= myYMoveMin) {
        _ynew=myYMoveMin;

        if(myState==STATE_ON)
            myState=BUMP_UP;
    }
}
    //
    myX=_xnew;
    myY=_ynew;

    myX1=_xnew;
    myY1=_ynew+myV1;

    myX2=_xnew+myU2;
    myY2=_ynew+myHeight;

    myX3=_xnew+myWidth;
    myY3=_ynew+myV2;

    myX4=_xnew+myU1;
    myY4=_ynew;

    this->draw();
}