#ifndef CIRCLE_H
#define CIRCLE_H

#include "Screen.h"
#include "Sprite.h"

class Circle:public Sprite
{
public:
    /** Construct a filled Circle
    *
    * @param mScreen the pointer screen
    * @param _id the identifier Id
    * @params _xc the center x
    * @params _yc the center y
    * @params _radius
    * @param _color the background color
    * @params _isVisible
    */
    Circle(Screen* mScreen,UINT16 _xc,UINT16 _yc,UINT16 _radius,Color _color);
    //
    virtual void draw(void);
    //
    virtual ~Circle(void);
    //
    void update(float delta);

// getter
    UINT16 getCenterX(void) const;
    //
    UINT16 getCenterY(void)const;

//setter
    void setInvisible(bool _state);
    //
    void setNewPosition(INT16 _xnew,INT16 _ynew);
    //
    void setNewPosition(INT16 _xnew,INT16 _ynew,bool isScreenLimits);
    //
    void setCenterX(UINT16 _xcenter);
    //
    void setCenterY(UINT16 _ycenter);

protected:
    UINT16 myRadius;
    UINT16 myCenterX;
    UINT16 myCenterY;
};

#endif