#include "Circle.h"

Circle::Circle(Screen* mScreen,UINT16 _xc,UINT16 _yc,UINT16 _radius,Color _color):
    Sprite(mScreen,0,_xc-_radius,_yc-_radius,_radius+_radius,_radius+_radius,_color)
{
    myRadius=_radius;
    myCenterX=_xc;
    myCenterY=_yc;
    myType=OBJ_CIRCLE;

    myScreen->addWidget((Widget*) this);

}
//-----------------------------------------
Circle::~Circle(void)
{
}
//------------------------------------------
void Circle::draw(void)
{
// isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_filled_circle(myCenterX,myCenterY,myRadius,myColor);
    }
    ps=0;
}
//------------------------------------------
void Circle::setCenterX(UINT16 _xcenter)
{
    this->myCenterX=_xcenter;
}
//------------------------------------------
void Circle::setCenterY(UINT16 _ycenter)
{
    this->myCenterY=_ycenter;
}
//------------------------------------------
UINT16 Circle::getCenterX(void) const
{
    return this->myCenterX;
}
//-------------------------------------------
UINT16 Circle::getCenterY(void) const
{
    return this->myCenterY;
}
//--------------------------------------------
void Circle::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_circle(myCenterX,myCenterY,myRadius,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//----------------------------------------------
void Circle::setNewPosition(INT16 _xcnew,INT16 _ycnew)
{
    setNewPosition(_xcnew,_ycnew,true);
}
//---------------------------------------------
void Circle::setNewPosition(INT16 _xcnew,INT16 _ycnew,bool isScreenLimits)
{
    if(myIsVisible==false)
        return;
    //
    if(myCenterX==_xcnew && myCenterY==_ycnew)
        return;
    //
    this->setInvisible(true); // colorie le cir avec couleur de la screen

    myIsVisible=true;

    if(isScreenLimits) {

        //test Xmax
        if(_xcnew+myRadius >= myXMoveMax) {
            _xcnew=myXMoveMax-myRadius;

            if(myState==STATE_ON)
                myState=BUMP_RIGHT;
        }

        //test Xmin
        if(_xcnew <= myRadius) {
            _xcnew=myXMoveMin+myRadius;

            if(myState==STATE_ON)
                myState=BUMP_LEFT;
        }
        //test Ymax
        if(_ycnew +myRadius >= myYMoveMax && _ycnew >0) {
            _ycnew = myYMoveMax- myRadius;

            if(myState==STATE_ON)
                myState=BUMP_DOWN;
        }
        //test yminMin;
        if(_ycnew <= myRadius) {
            _ycnew=myYMoveMin+myRadius;

            if(myState==STATE_ON)
                myState=BUMP_UP;
        }
    }
    //
    myCenterX=_xcnew;
    myCenterY=_ycnew;

    myX=_xcnew-myRadius;
    myY=_ycnew-myRadius;


    this->draw();
}
//----------------------------------------------
void Circle::update(float delta)
{
    if(myIsUpdateAutomatic)
        elementUpdate();

    float xcnew=myCenterX+mySpeedX*delta;
    float ycnew=myCenterY+mySpeedY*delta;

    this->setNewPosition((INT16)xcnew,(INT16)ycnew,true);

}