#ifndef BUZZER_H
#define BUZZER_H
#include "mbed.h"
#include <vector>

/** This is a simple sound library for mbed.I use the RTTTL format
http://en.wikipedia.org/wiki/Ring_Tone_Transfer_Language

Example
@code
#include "Buzzer.h"

char *song = "The Simpsons:d=4,o=5,b=160:c.6,e6,f#6,8a6,g.6,e6,c6,8a,8f#,8f#,8f#,2g,8p,8p,8f#,8f#,8f#,8g,a#.,8c6,8c6,8c6,c6";

Buzzer buzzer(p21);

Music* pMusic=0;    //the song
Note la("A#4",50);  //the sound

int main()
{
   pMusic= new Music(song);
   pMusic->play(&buzzer);

   buzzer.tone(&la);
   delete(pMusic);
}
@endcode
*/

// notes definition
#define NOTE_R      0

//octave 3
#define NOTE_C3     7644
#define NOTE_CS3    7215
#define NOTE_D3     6810
#define NOTE_DS3    6428
#define NOTE_E3     6067
#define NOTE_F3     5727
#define NOTE_FS3    5405
#define NOTE_G3     5102
#define NOTE_GS3    4815
#define NOTE_A3     4545
#define NOTE_AS3    4290
#define NOTE_B3     4049

//octave 4
#define NOTE_C4     3822
#define NOTE_CS4    3607
#define NOTE_D4     3405
#define NOTE_DS4    3214
#define NOTE_E4     3033
#define NOTE_F4     2863
#define NOTE_FS4    2702
#define NOTE_G4     2551
#define NOTE_GS4    2408
#define NOTE_A4     2272
#define NOTE_AS4    2145
#define NOTE_B4     2024

//octave 5
#define NOTE_C5     1911
#define NOTE_CS5    1804
#define NOTE_D5     1702
#define NOTE_DS5    1607
#define NOTE_E5     1516
#define NOTE_F5     1432
#define NOTE_FS5    1351
#define NOTE_G5     1275
#define NOTE_GS5    1204
#define NOTE_A5     1136
#define NOTE_AS5    1072
#define NOTE_B5     1012

//octave 6
#define NOTE_C6     956
#define NOTE_CS6    903
#define NOTE_D6     852
#define NOTE_DS6    803
#define NOTE_E6     759
#define NOTE_F6     716
#define NOTE_FS6    676
#define NOTE_G6     638
#define NOTE_GS6    602
#define NOTE_A6     568
#define NOTE_AS6    536
#define NOTE_B6     506

//octave 7
#define NOTE_C7     477
#define NOTE_CS7    451
#define NOTE_D7     426
#define NOTE_DS7    402
#define NOTE_E7     379
#define NOTE_F7     358
#define NOTE_FS7    338
#define NOTE_G7     319
#define NOTE_GS7    301
#define NOTE_A7     284
#define NOTE_AS7    268
#define NOTE_B7     253
//------------------------------
class Note
{
public:
    /** Construct a Note (sound) object.
       *
       * @param _note the note in range (A,a,B,b,C,c,D,d,E,e,F,f)
       * @param _isSharp exemple A4 or A#4
       * @param _duration the time duration
       */

    Note(char _note,bool _isSharp,char _octave,int _duration);

    /** Construct a Note (sound) object.
        *
        * @param str exemple "C%4" or "C#4"
        * @param _duration the time duration
        */

    Note(char* str,int _duration);// exemple "C%4" or "C#4"


//setter

//getter

    ///    @returns the note period (PwmOutput)
    int getNotePeriod_us(void)const ;

    ///    @returns is Sharp
    bool getIsSharp(void) const;

    ///    @returns the note char
    char getNoteChar(void) const;

    ///    @returns the octave
    char getOctave(void) const;

    ///    @returns the duartion in ms
    int getDuration(void) const;

    ///use in debugging
    void toString(char* buffer);


protected:

    int calculatePeriod_us(void);

    void parse(const char* _str);

    char myNoteChar;
    bool myIsSharp;
    char myOctave;  // 3->5
    int myPeriod_us;
    int myDuration;

};
//----------------------------------


class Buzzer:public PwmOut
{
public:
    /** Construct a Buzzer object.
           *
           * @param _pwmOut select the PwmOutput
           */

    Buzzer(PinName _pwmOut);
    //
    ~Buzzer();

    /// The Buzzer tone a simple sound
    void tone(const Note* _note);


protected:

};


//----------------------------------
class Music
{
public:
    /** Construct a Music  object.
       *
       * @param p the RTTTL song
       */
    Music(const char* p);

    ~Music();

    /// play the music
    void  play(Buzzer* _buzzer);

    ///    @returns the music lenght
    int getNumbersNotes(void) const;

protected:
    int nbNotes;
    vector<Note*> myTabNotes;


};

#endif