#include "Button.h"

Button::Button(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,string _text,Font _font,
               Color _colorText,Color _colorBtn,State _state):
    Widget(mScreen,_id,_x,_y,0,0,_colorBtn)

{
    myText=_text;
    myFont=_font;
    myColorText=_colorText;

    myState=_state;
    myType=OBJ_BUTTON;

    //
    UINT16 largeur=0;
    UINT16 hauteur=16;
    UINT16 taille=0;
    UINT16 incLargeur=12;

    switch(_font) {
            //
        case FONT_2:
            incLargeur=8;
            hauteur=8;
            largeur=8;
            break;

            //
        case FONT_3:
            incLargeur=8;
            hauteur=12;
            largeur=8;
            break;
            //
        case FONT_1:
            incLargeur=5;
            hauteur=7;
            largeur=5;
            break;

            //
        default:
            incLargeur=12;
            hauteur=16;
            largeur=8;
            break;
    }

    //cherche taille

    taille=_text.size();

    largeur=taille*incLargeur;

    if(largeur > incLargeur)
        largeur=largeur-incLargeur;

    myWidth=largeur+incLargeur+incLargeur;
    myHeight=hauteur+incLargeur+incLargeur;

    myScreen->addWidget((Widget*) this);

    //

}
//--------------------------------------
Button::~Button(void)
{
}
//---------------------------------------
void Button::draw(void)
{
    if(myIsVisible==false)
        return;

    State state=getState();

    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    switch(state) {
            //
        case BUTTON_STATE_PRESSED:
            if(ps!=0) {
                ps->draw_button(myText,myX,myY,myFont,BUTTON_STATE_PRESSED,myColor,WHITE);

            }
            ps=0;
            return;
            //
        case BUTTON_STATE_RELEASED:
            if(ps!=0) {
                ps->draw_button(myText,myX,myY,myFont,BUTTON_STATE_RELEASED,myColor,myColorText);

            }
            ps=0;
            return;
            //
        default:
            break;
    }
}

//-----------------------------------
void Button::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//------------------------------------
void Button::setState(State _state)
{
    if(myIsVisible==false)
        return;

    if(myState==_state)
        return;

    myState=_state;

    this->draw();
}