#include "Triangle.h"

Triangle::Triangle(Screen* mScreen,UINT16 _x1,UINT16 _y1,
                   UINT16 _x2,UINT16 _y2,
                   UINT16 _x3,UINT16 _y3,Color _color):
    Sprite(mScreen,0,_x2,_y1,_x3-_x2,_y3-_y1,_color)
{
    myX1=_x1;
    myY1=_y1;
    myX2=_x2;
    myY2=_y2;
    myX3=_x3;
    myY3=_y3;
    myU=_x1-_x2;
    myV=_y2-_y1;

    myType=OBJ_TRIANGLE;

    myScreen->addWidget((Widget*) this);
}
//-----------------------------------------------
Triangle::~Triangle(void)
{
}
//-----------------------------------------------
void Triangle::draw(void)
{
// isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_filled_triangle(myX1,myY1,myX2,myY2,myX3,myY3,myColor);
    }
    ps=0;
}
//------------------------------------------------
void Triangle::setInvisible(bool _state)
{
// element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_triangle(myX1,myY1,myX2,myY2,myX3,myY3,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;

        this->draw();
    }
}
//------------------------------------------------
void Triangle::setNewPosition(INT16 _xnew,INT16 _ynew)
{
    setNewPosition(_xnew,_ynew,true);
}
//------------------------------------------------
void Triangle::setNewPosition(INT16 _xnew,INT16 _ynew,bool isScreenLimits)
{
    if(myIsVisible==false)
        return;
    //
    if(myX==_xnew && myY==_ynew)
        return;
    setInvisible(true); // colorie le tri avec couleur de la screen

    myIsVisible=true;
    if(isScreenLimits) {
        //test Xmax
        if(_xnew+myWidth >= myXMoveMax) {
            _xnew=myXMoveMax-myWidth;

            if(myState==STATE_ON)
                myState=BUMP_RIGHT;
        }
        //
        //test Xmin
        if(_xnew <= myXMoveMin) {
            _xnew=myXMoveMin;

            if(myState==STATE_ON)
                myState=BUMP_LEFT;
        }
        //test Ymax
        if(_ynew +myHeight >= myYMoveMax && _ynew >0) {
            _ynew = myYMoveMax- myHeight;

            if(myState==STATE_ON)
                myState=BUMP_DOWN;
        }
        //test yminMin;
        if(_ynew <= myYMoveMin) {
            _ynew=myYMoveMin;

            if(myState==STATE_ON)
                myState=BUMP_UP;
        }
    }
    //
    myX=_xnew;
    myY=_ynew;

    myX1=_xnew+myU;
    myY1=_ynew;

    myX2=_xnew;
    myY2=_ynew+myV;

    myX3=_xnew+myWidth;
    myY3=_ynew+myHeight;

    this->draw();
}
//------------------------------------------------
void Triangle::update(float delta)
{
    if(myIsUpdateAutomatic)
        elementUpdate();
    //
    float xnew=myX+mySpeedX*delta;
    float ynew=myY+mySpeedY*delta;

    this->setNewPosition((INT16)xnew,(INT16)ynew,true);

}
