#include "Switcher.h"

Switcher::Switcher(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _width,UINT16 _height):
    Widget(mScreen,_id,_x,_y,_width,_height,WHITE)
{
    myColorOn=GREEN;
    myColorOff=RED;
    myColorCursor=WHITE;

    myType=OBJ_SWITCHER;
    myState=SWITCHER_STATE_OFF;

    myScreen->addWidget((Widget*) this);
}
//---------------------------------------
Switcher::~Switcher(void)
{
}
//---------------------------------------
void Switcher::draw(void)
{
    if(myIsVisible==false)
        return;
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    State state=myState;

    Color gauche=WHITE;
    Color droite=WHITE;

    switch(state) {
            //
        case SWITCHER_STATE_ON:
            droite=myColorOn;
            gauche=myColorCursor;
            break;

            //
        case SWITCHER_STATE_OFF:
            droite=myColorCursor;
            gauche=myColorOff;
            break;

            //
        default:
            break;
    }
    //

    //rect gauche
    if(ps!=0)
        ps->draw_filled_rectangle(myX,myY,myX+myWidth/2,myY+myHeight,gauche);

    //rect droite
    if(ps!=0)
        ps->draw_filled_rectangle(myX+myWidth/2,myY,myX+myWidth,myY+myHeight,droite);

    //cadre
    if(ps!=0) {
        ps->draw_rectangle(myX,myY,myX+myWidth,myY+myHeight,BLACK);
        ps->draw_rectangle(myX,myY,myX+myWidth/2,myY+myHeight,BLACK);

    }
    ps=0;

}
//----------------------------------------
void Switcher::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();
        PicasoSerial* ps=0;

        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//-----------------------------------------
void Switcher::setState(State _state)
{
    if(myIsVisible==false)
        return;

    if(myState==_state)
        return;

    myState=_state;

    this->draw();
}
//-----------------------------------------
void Switcher::changeState(GraphicMessage* msg)
{
    TouchEvent ev=msg->event;

    if(myIsVisible==false)
        return;

    if(ev==EVENT_PRESS && myState==SWITCHER_STATE_OFF) {
        this->setState(SWITCHER_STATE_ON);
        return;
    }
    //
    if(ev==EVENT_PRESS && myState==SWITCHER_STATE_ON) {
        this->setState(SWITCHER_STATE_OFF);
        return;
    }
    //
    if(ev==EVENT_MOVE || ev==EVENT_RELEASE)
        return;
}