#include "Slider.h"

Slider::Slider(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _width,UINT16 _height,int _valMax,int _value,
               Color _colorBkg):
    Widget(mScreen,_id,_x,_y,_width,_height,_colorBkg)
{

    myValueMax=_valMax;
    myValue=_value;

    myType=OBJ_SLIDER;
    myState=SLIDER_STATE_RELEASED;

    myScreen->addWidget((Widget*) this);
}
//---------------------------------------
Slider::~Slider(void)
{
}
//---------------------------------------
void Slider::draw(void)
{
    if(myIsVisible==false)
        return;

    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_slider(0x0000,myX,myY,myX+myWidth,myY+myHeight,myColor,myValueMax,myValue);
    }
    ps=0;

}
//--------------------------------------
void Slider::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//-------------------------------------
int Slider::getValue(GraphicMessage* pmsg)
{
    TouchEvent msgEvent=pmsg->event;

    UINT16 xn=pmsg->posiX;


    if(myIsVisible==false)
        return 0;
    //

    if(msgEvent==EVENT_RELEASE) {
        myState=SLIDER_STATE_RELEASED;
    }
    //
    if(msgEvent==EVENT_MOVE) {
        myState=SLIDER_STATE_MOVE;
        UINT16 dis=xn-myX;
        UINT16 a=dis*myValueMax;
        myValue=(a/myWidth);

        this->draw();
    }
    return myValue;
}