#include "Segment.h"

Segment::Segment(Screen* mScreen,UINT16 _x1,UINT16 _y1,UINT16 _x2,UINT16 _y2,Color _color):
    Widget(mScreen,0,_x1,_y1,0,0,_color)
{
    myX1=_x1;
    myY1=_y1;
    myX2=_x2;
    myY2=_y2;

    myType=OBJ_SEGMENT;

    myScreen->addWidget((Widget*)this);
}
//------------------------------------------
void Segment::draw(void)
{
    if(myIsVisible==false)
        return;

    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_line(myX1,myY1,myX2,myY2,myColor);
    }
    ps=0;
}
//------------------------------------------
Segment::~Segment(void)
{
}
//-------------------------------------------
void Segment::setInvisible(bool _state)
{
    if(_state==true) {
        if(myIsVisible==false)
            return;
        //
        myIsVisible=false;
        Color c=myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0)
            ps->draw_line(myX1,myY1,myX2,myY2,c);
            ps=0;
    }
    //
    else {
        myIsVisible=true;
        this->draw();
    }
}
//---------------------------------------------
void Segment::setNewCoord(UINT16 _x1,UINT16 _y1,UINT16 _x2,UINT16 _y2)
{
    if(myIsVisible==false)
        return;

    if(myX1==_x1 && myY1==_y1 && myX2==_x2 && myY2==_y2)
        return;

    this->setInvisible(true);

    myX1=_x1;
    myY1=_y1;
    myX2=_x2;
    myY2=_y2;

    this->setInvisible(false);
}