#ifndef SCREEN_H
#define SCREEN_H

#include "mbed.h"
#include "PicasoSerial.h"
#include <string>
#include <vector>

///
class Widget;
/////////

class Screen
{
public:
    /** Construct a Screen
    *
    * @param serial the PicasoSerial Obj
    * @param _x the up left
    * @params _y the up left
    * @params _w the width
    * @params _h the height
    * @param _colorBkg the background color
    */
    // constructeur
    Screen(PicasoSerial* serial,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _colorBkg);
    //
    virtual ~Screen(void);
    //
    //! draw all objects
    void drawAllWidget(void);
    //------------------------------
    //! add a new Objet
    void addWidget(Widget* pObj);
    //
    //! draw a particular object
    void drawWidget(Widget* pObj);
    //
    //! @returns PicasoSerial the pointer to draw on the screen
    PicasoSerial* getPicasoSerial(void) const;
    //
     void setClear();

//getter
    UINT16 getXpos(void) const;
    UINT16 getYpos(void) const;
    UINT16 getWidth(void) const;
    UINT16 getHeight(void) const;
    Color getColorBkg(void) const;

    bool isContent(Widget* pObj, UINT16 _x,UINT16 _y);

    //-----------------------------------------------------
    //! returns the Objet in [_x,_y] position
    Widget* getWidgetPosition(UINT16 _x,UINT16 _y);
    
    //! returns the Objet by Id
    Widget* getWidgetById(UINT16 _id);

    //-----------------------------------------------------
    //! returns the touch and update the GraphicMessage
    TouchEvent getTouchEvent(GraphicMessage* msg);

    //-------------------------------------------
    //! update the identifier Id of the object being touched
    void getProcessMessage(GraphicMessage* msg);

protected:
    PicasoSerial* mySerial;

    UINT16 myXpos,myYpos,myWidth,myHeight;

    Color myColorBkg;

    vector<Widget*> myVectorObjet;
};

///////////////////////////////
class Widget
{
public:
    /** Construct a Widget the father
    *
    * @param mScreen the pointer screen
    * @param _id the identifier Id
    * @params _x the up left
    * @params _y the up left
    * @params _w the width
    * @params _h the height
    * @param _color the background color
    * @params _isVisible
    */
// constructor
    //
    Widget(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _color);
    //
    //! draw the obj
    virtual void draw(void);
    //
    virtual ~Widget(void);
    //
   
    UINT16 getXposition(void) const;
    UINT16 getYposition(void) const;
    UINT16 getWidth(void) const;
    UINT16 getHeight(void) const;
    UINT16 getId(void) const;
    bool   getIsVisible(void) const;
    State getState(void) const;
    Color getColor(void) const;


    void setColor(Color _color);
    void setState(State _state);
    void setId(UINT16 _id);
    void setVisibility(bool _val);
    void setXposition(UINT16 _xpos);
    void setYposition(UINT16 _ypos);
   

    WIDGET_TYPE getType(void) const;



protected:
    Screen* myScreen;

    UINT16 myX,myY,myWidth,myHeight;
    UINT16 myId;
    WIDGET_TYPE myType;

    bool myIsVisible;
    
    State myState;
    Color myColor;
};
#endif