#ifndef SCALER_H
#define SCALER_H

#include "Screen.h"

class Scaler:public Widget
{
public:
    /** Construct a Input
        *
        * @param mScreen the pointer screen
        * @param _id the identifier Id
        * @params _x up left
        * @params _y up left
        * @params _width
        * @params _height
        * @params _valMin
        * @params _valInc incrementing the value
        * @params _valMax
        */
    Scaler(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _width,UINT16 _height,float _valMin,float _valInc,
          float _valMax);
    //
    virtual void draw(void);
    //
    virtual ~Scaler(void);
    //
    void setInvisible(bool _state);
    //
    float getValue(GraphicMessage* msg);
    //
    void setColorBkg(Color _color);
    //
    void setColorCursorDown(Color _color);
    //
    void setColorCursorUp(Color _color);

protected:
    float myValMin;
    float myValInc;
    float myValMax;
    float myValue;
    Color myColorBkg;
    Color myColorCursorUp;
    Color myColorCursorDown;
};
#endif
