#include "Scaler.h"

Scaler::Scaler(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,UINT16 _width,UINT16 _height,float _valMin,float _valInc,
               float _valMax):
    Widget(mScreen,_id,_x,_y,_width,_height,WHITE)
{
    myValMin=_valMin;
    myValInc=_valInc;
    myValMax=_valMax;
    myValue=0.0;
    myColorBkg=WHITE;
    myColorCursorUp=BLUE;
    myColorCursorDown=BLUE;

    myType=OBJ_SCALER;
    myState=SCALER_STATE_RELEASED;

    myScreen->addWidget((Widget*) this);
}
//-------------------------------------
Scaler::~Scaler(void)
{
}
//-------------------------------------
void Scaler::setColorBkg(Color _color)
{
    myColorBkg=_color;
    this->draw();
}
//--------------------------------------
void Scaler::setColorCursorUp(Color _color)
{
    myColorCursorUp=_color;
    this->draw();
}
//-------------------------------------
void Scaler::setColorCursorDown(Color _color)
{
    myColorCursorDown=_color;
    this->draw();
}
//-------------------------------------
void Scaler::draw(void)
{
    if(myIsVisible==false)
        return;
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    //rect up
    if(ps!=0)
        ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight/2,myColorBkg);

    //rect down
    if(ps!=0)
        ps->draw_filled_rectangle(myX,myY+myHeight/2+3,myX+myWidth,myY+3+myHeight,myColorBkg);

    //fleche up
    UINT16 x1=myX+myWidth/2;
    UINT16 y1=myY;

    UINT16 x2=myX+myWidth;
    UINT16 y2=myY+myHeight/2;

    UINT16 x3=myX;
    UINT16 y3=myY+myHeight/2;
    if(ps!=0)
        ps->draw_filled_triangle(x1,y1,x2,y2,x3,y3, myColorCursorUp);

    //fleche down
    x1=myX;
    y1=myY+3+myHeight/2;

    x2=myX+myWidth;
    y2=y1;

    x3=myX+myWidth/2;
    y3=y2+myHeight/2;
    if(ps!=0)
        ps->draw_filled_triangle(x1,y1,x2,y2,x3,y3, myColorCursorDown);

    //cadre
    if(ps!=0)
        ps->draw_rectangle(myX,myY,myX+myWidth,myY+myHeight+3,BLACK);
        
    ps=0;

}
//-------------------------------------
void Scaler::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight+3,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//--------------------------------------
float Scaler::getValue(GraphicMessage* msg)
{
    if(myIsVisible==false)
        return 0.0;
        
    float val=0.0;
    //
    TouchEvent ev=msg->event;
    UINT16 yn=msg->posiY;

    UINT16 y0=myY;
    UINT16 ybut1=y0+myHeight/2;
    UINT16 ybut2=y0+myHeight;
    Color couleurUp=myColorCursorUp;
    Color couleurDown=myColorCursorDown;

    if(ev==EVENT_PRESS && myState==SCALER_STATE_RELEASED) {
        //up ?
        if(yn >= y0 && yn <= ybut1) {
            myState=SCALER_STATE_PRESSED_UP;
            setColorCursorUp(WHITE);
            wait(0.1);
            setColorCursorUp(couleurUp);

            val=myValue+myValInc;
            if(val >myValMax)
                val=myValMax;

            myValue=val;
        }
        //
        //down?
        if(yn >= ybut1 && yn <= ybut2) {
            myState=SCALER_STATE_PRESSED_DOWN;
            setColorCursorDown(WHITE);
            wait(0.1);
            setColorCursorDown(couleurDown);

            val=myValue-myValInc;
            if(val <myValMin)
                val=myValMin;

            myValue=val;
        }
    }
    //
    if(ev==EVENT_RELEASE || ev==EVENT_MOVE) {
        myState=SCALER_STATE_RELEASED;
    }

    return myValue;
}