#include "Rectangle.h"


Rectangle::Rectangle(Screen* mScreen,UINT16 _x,UINT16 _y,UINT16 _w,UINT16 _h,Color _color):
    Sprite(mScreen,0,_x,_y,_w,_h,_color)

{
    myType=OBJ_RECTANGLE;

    myScreen->addWidget((Widget*) this);
}
//------------------------------------
Rectangle::~Rectangle(void)
{

}
//------------------------------------
void Rectangle::draw(void)
{
    // isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,myColor);
    }
}
//-------------------------------------
void Rectangle::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
    }

    // element devient visible
    else {
        myIsVisible=true;

        this->draw();
    }
}
//--------------------------------------
void Rectangle::setNewPosition(INT16 _xnew,INT16 _ynew)
{
    setNewPosition(_xnew,_ynew,true);
}
//--------------------------------------
void Rectangle::setNewPosition(INT16 _xnew,INT16 _ynew,bool isScreenLimits)
{
    if(myIsVisible==false)
        return;

    //
    if(myX==_xnew && myY==_ynew)
        return;

    setInvisible(true); // colorie le rec avec couleur de la screen

    myIsVisible=true;

    if(isScreenLimits) {
        //test Xmax
        if(_xnew+myWidth >= myXMoveMax) {
            _xnew=myXMoveMax-myWidth;

            if(myState==STATE_ON)
                myState=BUMP_RIGHT;

        }

        //test Xmin
        if(_xnew <= myXMoveMin) {
            _xnew=myXMoveMin;

            if(myState==STATE_ON)
                myState=BUMP_LEFT;

        }
        //test Ymax
        if(_ynew +myHeight >= myYMoveMax && _ynew >0) {
            _ynew = myYMoveMax- myHeight;

            if(myState==STATE_ON)
                myState=BUMP_DOWN;
        }
        //test yminMin;
        if(_ynew <= myYMoveMin) {
            _ynew=myYMoveMin;

            if(myState==STATE_ON)
                myState=BUMP_UP;

        }
    }
    //
    myX=_xnew;
    myY=_ynew;


    this->draw();
}
//--------------------------------------
void Rectangle::update(float delta)
{
    if(myIsUpdateAutomatic)
        elementUpdate();
    //
    float xnew=myX+mySpeedX*delta;
    float ynew=myY+mySpeedY*delta;

    this->setNewPosition((INT16)xnew,(INT16)ynew,true);

}