#include "PicasoSerial.h"

PicasoSerial::PicasoSerial(PinName _pinTx,PinName _pinRx,PinName _pinReset):Serial(_pinTx,_pinRx),myPinReset(_pinReset)
{
    this->baud(9600);
    myPinReset=1;
}
//--------------------------------------------
//
//--------------------------------------------
// fonction Touch Screen
//--------------------------------------------
void PicasoSerial::touch_set(UINT16 mode)
{
    unsigned char zecom[4] = "";

    zecom[0] = (CMD_TOUCH_SET >> 8) & 0xFF;
    zecom[1] = CMD_TOUCH_SET & 0xFF;

    zecom[2] = (mode >> 8) & 0xFF;
    zecom[3] = mode & 0xFF;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();
}
//------------------------------------------------
void PicasoSerial::touch_detect_region(UINT16 x1, UINT16 y1, UINT16 x2, UINT16 y2)
{
    unsigned char zecom[10] = "";

    zecom[0] = (CMD_TOUCH_DETECT_REGION >> 8) & 0xFF;
    zecom[1] = CMD_TOUCH_DETECT_REGION & 0xFF;

    zecom[2] = (x1 >> 8)&0xFF;
    zecom[3] = x1 & 0xFF;

    zecom[4] = (y1 >> 8)&0xFF;
    zecom[5] = y1 & 0xFF;

    zecom[6] = (x2 >> 8)&0xFF;
    zecom[7] = x2 & 0xFF;

    zecom[8] = (y2 >> 8)&0xFF;
    zecom[9] = y2 & 0xFF;

    put_gfx_Commande(zecom, 10);

    wait_gfx_ack();
}
//--------------------------------------
TouchEvent PicasoSerial::touch_get_status()
{
    //0 No touch
    //1 press
    //2 release
    //3 moving

    UINT8 msb = 0;
    UINT8 lsb = 0;

    // TouchEvent res = EVENT_NO_ACTIVITY;
    UINT16 temp=0;

    unsigned char zecom[4] = "";

    zecom[0] = (CMD_TOUCH_GET >> 8) & 0xFF;
    zecom[1] = CMD_TOUCH_GET & 0xFF;

    zecom[2] = 0x00;
    zecom[3] = 0x00;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();

    msb = get_gfx_char();

    lsb = get_gfx_char();

    temp=(msb << 8) + lsb;

    switch(temp) {
        case 0:
            return EVENT_NO_ACTIVITY;

            //
        case 1:
            return EVENT_PRESS;

            //
        case 2:
            return EVENT_RELEASE;

            //
        case 3:
            return EVENT_MOVE;
    }

    return EVENT_NO_ACTIVITY;
}
//--------------------------------
UINT16 PicasoSerial::touch_get_x()
{
    UINT16 res = 0;
    UINT8 lsb = 0;
    UINT8 msb = 0;

    unsigned char zecom[4] = "";

    zecom[0] = (CMD_TOUCH_GET >> 8) & 0xFF;
    zecom[1] = CMD_TOUCH_GET & 0xFF;

    zecom[2] = 0x00;
    zecom[3] = 0x01;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();

    msb = get_gfx_char();

    lsb = get_gfx_char();

    res = (msb << 8) + lsb;

    return res;
}
//--------------------------------
UINT16 PicasoSerial::touch_get_y()
{
    UINT16 res = 0;
    UINT8 lsb = 0;
    UINT8 msb = 0;

    unsigned char zecom[4] = "";

    zecom[0] = (CMD_TOUCH_GET >> 8) & 0xFF;
    zecom[1] = CMD_TOUCH_GET & 0xFF;

    zecom[2] = 0x00;
    zecom[3] = 0x02;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();

    msb = get_gfx_char();

    lsb = get_gfx_char();

    res = (msb << 8) + lsb;

    return res;
}
//-----------------------------
void PicasoSerial::gfx_reset()
{
    // reSet uLCD
    //*****************************
    myPinReset = 0;

    wait_us(10);

    myPinReset = 1;
    //******************************
    // fin reset

    wait(5); //wait 5s after reset
}
//-------------------------------------
void PicasoSerial::setup(int baud)
{
    gfx_reset();

    gfx_set_BackGroundColor(WHITE);

    touch_detect_region(0, 0, 240, 320);
    //
    touch_set(0x0000);

    gfx_clearScreen();

    gfx_set_UartSpeed(baud);
}
//-------------------------------
void PicasoSerial::wait_gfx_ack()
{
    UINT8 rep = GFX_NAK;

    do {
        rep = get_gfx_char();
    } while (rep != GFX_ACK);
}
//-------------------------------------------------
void PicasoSerial::put_gfx_char(unsigned char data)
{

    while (this->writeable()==0); // buffer plein ?

    this->putc(data);
}
//------------------------------------
UINT8 PicasoSerial::get_gfx_char(void)
{
    while (this->readable()==0); // attendre data

    //return mySerial.getc();

    return this->getc();
}
//----------------------------------------------------------------------
void PicasoSerial::put_gfx_Commande(unsigned char* commande, int nombre)
{
    int i = 0;

    for (i = 0; i < nombre; i++) {
        put_gfx_char(commande[i]);
    }
}
//--------------------------------------------
void PicasoSerial::gfx_set_UartSpeed(int speed)
{
    int mbaud = 0;

    unsigned char zecom[4] = "";

    zecom[0] = (CMD_BAUD_RATE >> 8)& 0xFF;
    zecom[1] = CMD_BAUD_RATE & 0xFF;

    switch (speed) {
            //
        case 9600:
            zecom[2] = (GFX_BAUD_9600 >> 8)& 0xFF;
            zecom[3] = GFX_BAUD_9600 & 0xFF;
            mbaud = speed;

            break;
            //
        case 19200:
            zecom[2] = (GFX_BAUD_19200 >> 8) & 0xFF;
            zecom[3] = GFX_BAUD_19200 & 0xFF;
            mbaud = speed;

            break;
            //
        case 56000:
            zecom[2] = (GFX_BAUD_56000 >> 8) & 0xFF;
            zecom[3] = GFX_BAUD_56000 & 0xFF;
            mbaud = speed;

            break;
            //
        case 115200:
            zecom[2] = (GFX_BAUD_115200 >> 8) & 0xFF;
            zecom[3] = GFX_BAUD_115200 & 0xFF;
            mbaud = speed;

            break;

            //
        case 128000:
            zecom[2] = (GFX_BAUD_128000 >> 8) & 0xFF;
            zecom[3] = GFX_BAUD_128000 & 0xFF;
            mbaud = speed;

            break;
            //
        case 256000:
            zecom[2] = (GFX_BAUD_256000 >> 8) & 0xFF;
            zecom[3] = GFX_BAUD_256000 & 0xFF;
            mbaud = speed;
            break;


        default:
            zecom[2] = (GFX_BAUD_9600 >> 8) & 0xFF;
            zecom[3] = GFX_BAUD_9600 & 0xFF;
            mbaud = 9600;

            break;
    }
    //
    put_gfx_Commande(zecom, 4);

    wait_ms(50);
    this->baud(mbaud);
    wait_ms(100);

    wait_gfx_ack();
}
//----------------------------------
void PicasoSerial::gfx_clearScreen()
{
    unsigned char zecom [2] = "";
    //
    zecom[0] = (CMD_CLEAR_SCREEN >> 8)&0xFF; //0xFFCD
    zecom[1] = (CMD_CLEAR_SCREEN & 0xFF);

    put_gfx_Commande(zecom, 2);

    wait_gfx_ack();
}
//-----------------------------------------------------
void PicasoSerial::gfx_set_BackGroundColor(Color color)
{
    unsigned char zecom [4] = "";

    zecom[0] = (CMD_BACKGROUND_COLOR >> 8) & 0xFF; // 0xFFA4
    zecom[1] = CMD_BACKGROUND_COLOR & 0xFF;

    zecom[2] = (color >> 8)& 0xFF;
    zecom[3] = color & 0xFF;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();
}
//----------------------------------------------
unsigned short gfx_set_RGB565(unsigned char red,
                              unsigned char green,
                              unsigned char blue)
{
    UINT16 r = (red * 31) / 255;

    UINT16 v = (green * 63) / 255;

    UINT16 b = (blue * 31) / 255;

    return (r << 11) | (v << 5) | b;

}
//-----------------------------------------------------------------------------
void PicasoSerial::draw_circle(UINT16 x, UINT16 y, UINT16 radius,Color color)
{
    unsigned char zecom [10] = "";

    zecom[0] = (CMD_CIRCLE >> 8)&0xFF;
    zecom[1] = CMD_CIRCLE & 0xFF;

    // coord X[msb:Lsb]
    zecom[2] = (x >> 8)& 0xFF;
    zecom[3] = (x)& 0xFF;

    // coord Y[msb:Lsb]
    zecom[4] = (y >> 8)& 0xFF;
    zecom[5] = (y)& 0xFF;

    // rayon
    zecom[6] = (radius >> 8)& 0xFF;
    zecom[7] = (radius)& 0xFF;

    zecom[8] = (color >> 8) & 0xFF;
    zecom[9] = color & 0xFF;

    put_gfx_Commande(zecom, 10);

    wait_gfx_ack();
}
//------------------------------------------------------------------------------------
void PicasoSerial::draw_filled_circle(UINT16 x, UINT16 y, UINT16 radius,Color color)
{
    unsigned char zecom [10] = "";

    zecom[0] = (CMD_FILLED_CIRCLE >> 8)&0xFF;
    zecom[1] = CMD_FILLED_CIRCLE & 0xFF;

    // coord X[msb:Lsb]
    zecom[2] = (x >> 8)& 0xFF;
    zecom[3] = (x)& 0xFF;

    // coord Y[msb:Lsb]
    zecom[4] = (y >> 8)& 0xFF;
    zecom[5] = (y)& 0xFF;

    // rayon
    zecom[6] = (radius >> 8)& 0xFF;
    zecom[7] = (radius)& 0xFF;

    zecom[8] = (color >> 8) & 0xFF;
    zecom[9] = color & 0xFF;

    put_gfx_Commande(zecom, 10);

    wait_gfx_ack();
}
//------------------------------------------------------------
void PicasoSerial::draw_line(UINT16 x1, UINT16 y1,
                             UINT16 x2, UINT16 y2,Color color)
{
    unsigned char zecom [12] = "";

    zecom[0] = (CMD_LINE >> 8)& 0xFF;
    zecom[1] = CMD_LINE & 0xFF;

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1)& 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1)& 0xFF;

    // coord X2[msb:lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2)& 0xFF;

    // coord Y2[msb:lsb]
    zecom[8] = (y2 >> 8) & 0xFF;
    zecom[9] = y2 & 0xFF;

    zecom[10] = (color >> 8) & 0xFF;
    zecom[11] = color & 0xFF;

    put_gfx_Commande(zecom, 12);

    wait_gfx_ack();
}
//-----------------------------------------------------------------------------
void PicasoSerial::draw_triangle(UINT16 x1, UINT16 y1, UINT16 x2,
                                 UINT16 y2, UINT16 x3, UINT16 y3,Color color)
{
    unsigned char zecom [16] = "";

    zecom[0] = (CMD_TRIANGLE >> 8) & 0xFF;
    zecom[1] = CMD_TRIANGLE & 0xFF;

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1) & 0xFF;

    // coord X2[msb:lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2) & 0xFF;

    // coord Y2[msb:lsb]
    zecom[8] = (y2 >> 8) & 0xFF;
    zecom[9] = (y2) & 0xFF;

    //cord X3[msb:lsb]
    zecom[10] = (x3 >> 8) & 0xFF;
    zecom[11] = (x3) & 0xFF;

    //cord Y3[msb:lsb]
    zecom[12] = (y3 >> 8) & 0xFF;
    zecom[13] = (y3) & 0xFF;

    zecom[14] = (color >> 8) & 0xFF;
    zecom[15] = color & 0xFF;

    put_gfx_Commande(zecom, 16);

    wait_gfx_ack();
}
//-----------------------------------------------------------------------------------
void PicasoSerial::draw_filled_triangle(UINT16 x1, UINT16 y1, UINT16 x2,
                                        UINT16 y2, UINT16 x3, UINT16 y3,Color color)
{
    unsigned char zecom [16] = "";

    zecom[0] = (CMD_FILLED_TRIANGLE >> 8) & 0xFF;
    zecom[1] = CMD_FILLED_TRIANGLE & 0xFF;

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1) & 0xFF;

    // coord X2[msb:lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2) & 0xFF;

    // coord Y2[msb:lsb]
    zecom[8] = (y2 >> 8) & 0xFF;
    zecom[9] = (y2) & 0xFF;

    //cord X3[msb:lsb]
    zecom[10] = (x3 >> 8) & 0xFF;
    zecom[11] = (x3) & 0xFF;

    //cord Y3[msb:lsb]
    zecom[12] = (y3 >> 8) & 0xFF;
    zecom[13] = (y3) & 0xFF;

    zecom[14] = (color >> 8) & 0xFF;
    zecom[15] = color & 0xFF;

    put_gfx_Commande(zecom, 16);

    wait_gfx_ack();
}
//----------------------------------------------------------------------
void PicasoSerial::draw_filled_rectangle(UINT16 x1, UINT16 y1, UINT16 x2,
        UINT16 y2,Color color)
{
    unsigned char zecom [12] = "";

    zecom[0] = (CMD_FILLED_RECT >> 8)&0xFF;
    zecom[1] = (CMD_FILLED_RECT & 0xFF);

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1) & 0xFF;

    // coord X2[msb:lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2) & 0xFF;

    // coord Y2[msb:lsb]
    zecom[8] = (y2 >> 8) & 0xFF;
    zecom[9] = (y2) & 0xFF;

    // color
    zecom[10] = (color >> 8) & 0xFF;
    zecom[11] = color & 0xFF;

    put_gfx_Commande(zecom, 12);

    wait_gfx_ack();
}
//----------------------------------------------------------------
void PicasoSerial::draw_rectangle(UINT16 x1, UINT16 y1, UINT16 x2,
                                  UINT16 y2,Color color)
{
    unsigned char zecom [12] = "";

    zecom[0] = (CMD_RECT >> 8)&0xFF;
    zecom[1] = (CMD_RECT & 0xFF);

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1) & 0xFF;

    // coord X2[msb:lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2) & 0xFF;

    // coord Y2[msb:lsb]
    zecom[8] = (y2 >> 8) & 0xFF;
    zecom[9] = (y2) & 0xFF;

    // color
    zecom[10] = (color >> 8) & 0xFF;
    zecom[11] = color & 0xFF;

    put_gfx_Commande(zecom, 12);

    wait_gfx_ack();
}
//-----------------------------------------------------------------------------
void PicasoSerial::draw_panel(UINT16 state, UINT16 x1, UINT16 y1, UINT16 width,
                              UINT16 height,Color color)
{
    unsigned char zecom [10] = "";

    zecom[0] = (CMD_PANEL >> 8) & 0xFF;
    zecom[1] = (CMD_PANEL & 0xFF);

    // coord state[msb:Lsb]0 recessed, 1 raised
    zecom[2] = (state >> 8)& 0xFF;
    zecom[3] = (state) & 0xFF;

    // coord X1[msb:Lsb]
    zecom[4] = (x1 >> 8)& 0xFF;
    zecom[5] = (x1) & 0xFF;

    // coord X1[msb:Lsb]
    zecom[6] = (y1 >> 8)& 0xFF;
    zecom[7] = (y1) & 0xFF;

    // coord width[msb:Lsb]
    zecom[8] = (width >> 8)& 0xFF;
    zecom[9] = (width) & 0xFF;

    // coord height[msb:lsb]
    zecom[10] = (height >> 8)& 0xFF;
    zecom[11] = (height) & 0xFF;

    // color
    zecom[12] = (color >> 8) & 0xFF;
    zecom[13] = color & 0xFF;

    put_gfx_Commande(zecom, 14);

    wait_gfx_ack();
}
//----------------------------------------------------------------
void PicasoSerial::draw_pixel(UINT16 x1, UINT16 y1,Color color)
{
    unsigned char zecom [8] = "";

    zecom[0] = (CMD_PIXEL >> 8)& 0xFF;
    zecom[1] = CMD_PIXEL & 0xFF;

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1) & 0xFF;

    // color
    zecom[6] = (color >> 8) & 0xFF;
    zecom[7] = color & 0xFF;

    put_gfx_Commande(zecom, 8);

    wait_gfx_ack();
}
//-------------------------------------------------------------------------------------
void PicasoSerial::draw_slider(UINT16 mode, UINT16 x1, UINT16 y1, UINT16 x2, UINT16 y2,
                               Color color, UINT16 scale, UINT16 value)
{
    unsigned char zecom [18] = "";

    zecom[0] = (CMD_SLIDER >> 8)& 0xFF;
    zecom[1] = CMD_SLIDER & 0xFF;

    //mode
    zecom[2] = (mode >> 8)& 0xFF;
    zecom[3] = (mode) & 0xFF;

    // coord X1[msb:Lsb]
    zecom[4] = (x1 >> 8)& 0xFF;
    zecom[5] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[6] = (y1 >> 8)& 0xFF;
    zecom[7] = (y1) & 0xFF;

    // coord X2[msb:Lsb]
    zecom[8] = (x2 >> 8)& 0xFF;
    zecom[9] = (x2) & 0xFF;

    // coord Y2[msb:Lsb]
    zecom[10] = (y2 >> 8)& 0xFF;
    zecom[11] = (y2) & 0xFF;

    // color
    zecom[12] = (color >> 8) & 0xFF;
    zecom[13] = color & 0xFF;

    // scale
    zecom[14] = (scale >> 8) & 0xFF;
    zecom[15] = scale & 0xFF;

    //value
    zecom[16] = (value >> 8) & 0xFF;
    zecom[17] = value & 0xFF;

    put_gfx_Commande(zecom, 18);

    wait_gfx_ack();
}
//----------------------------------------------------------------------------------
void PicasoSerial::draw_button(string str, UINT16 x1, UINT16 y1,Font font,
                               State state,Color button_color,Color text_color)
{
    int i = 0;

    int taille = 0;
    unsigned char zecom [200] = "";

    // cherche taille
    /*
    while (*s) {
        size++;
        s++;

    }

    s = s - size;
    */
    taille=str.size();

    zecom[0] = (CMD_BUTTON >> 8)&0xFF;
    zecom[1] = CMD_BUTTON & 0xFF;

    //etat  0 depressed, 1 raised
    zecom[2] = (state >> 8) & 0xFF;
    zecom[3] = state & 0xFF;

    // coord X1[msb:Lsb]
    zecom[4] = (x1 >> 8)& 0xFF;
    zecom[5] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[6] = (y1 >> 8)& 0xFF;
    zecom[7] = (y1) & 0xFF;

    // button color
    zecom[8] = (button_color >> 8) & 0xFF;
    zecom[9] = button_color & 0xFF;

    //text color
    zecom[10] = (text_color >> 8) & 0xFF;
    zecom[11] = text_color & 0xFF;

    // font id
    zecom[12] = (font >> 8)&0xFF;
    zecom[13] = font & 0xFF;

    //txtWidth
    zecom[14] = 0x00;
    zecom[15] = 0x01;

    //txtHeight
    zecom[16] = 0x00;
    zecom[17] = 0x01;


    //le text
    for (i = 0; i < taille; i++) {
        zecom[18 + i] = str[i];
    }

    //terminate
    zecom[18 + taille] = 0x00;

    put_gfx_Commande(zecom, 19 + taille);

    wait_gfx_ack();
}
//-------------------------------------------------
void PicasoSerial::gfx_move_to(UINT16 x1, UINT16 y1)
{
    unsigned char zecom [6] = "";

    //move origine
    zecom[0] = (CMD_MOVE_ORIGIN >> 8) & 0xFF;
    zecom[1] = (CMD_MOVE_ORIGIN)& 0xFF;

    // coord X1[msb:Lsb]
    zecom[2] = (x1 >> 8)& 0xFF;
    zecom[3] = (x1) & 0xFF;

    // coord Y1[msb:Lsb]
    zecom[4] = (y1 >> 8)& 0xFF;
    zecom[5] = (y1) & 0xFF;

    put_gfx_Commande(zecom, 6);

    wait_gfx_ack();
}
//----------------------------------------------
void PicasoSerial::text_foreground(Color color)
{
    UINT8 rep = 0;

    unsigned char zecom [4] = "";

    zecom[0] = (CMD_TEXT_FOREGROUND >> 8) & 0xFF;
    zecom[1] = CMD_TEXT_FOREGROUND & 0xFF;

    zecom[2] = (color >> 8)& 0xFF;
    zecom[3] = color & 0xFF;

    put_gfx_Commande(zecom, 4); // ack?

    wait_gfx_ack();

    rep = get_gfx_char(); //previous color msb

    rep = get_gfx_char(); //previous color lsb
}
//---------------------------------------------
void PicasoSerial::text_backround(Color color)
{
    UINT8 rep = 0;

    unsigned char zecom [4] = "";

    zecom[0] = (CMD_TEXT_BACKROUND >> 8) & 0xFF;
    zecom[1] = CMD_TEXT_BACKROUND & 0xFF;

    zecom[2] = (color >> 8)& 0xFF;
    zecom[3] = color & 0xFF;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();

    rep = get_gfx_char(); //previous color msb

    rep = get_gfx_char(); //previous color lsb
}
//-------------------------------------------
void PicasoSerial::text_setFont(Font _font)
{
    UINT8 rep = 0;

    unsigned char zecom [4] = "";

    zecom[0] = (CMD_TEXT_SET_FONT >> 8) & 0xFF;
    zecom[1] = CMD_TEXT_SET_FONT & 0xFF;

    zecom[2] = (_font >> 8)& 0xFF;
    zecom[3] = _font & 0xFF;

    put_gfx_Commande(zecom, 4);

    wait_gfx_ack();

    rep = get_gfx_char();

    rep = get_gfx_char();
}
//----------------------------------------
void PicasoSerial::text_putstring(string str)
{
    int i = 0;
    UINT8 rep = 0;
    int taille = 0;
    unsigned char zecom [500] = "";


    // cherche taille
    /*
    while (*s) {
        size++;
        s++;

    }

    s = s - size;
    */
    taille=str.size();
    //
    zecom[0] = (CMD_PUT_STRING >> 8)& 0xFF;
    zecom[1] = CMD_PUT_STRING & 0xFF;


    //le text
    for (i = 0; i <taille; i++) {
        zecom[2 + i] = str[i];
    }

    //terminate
    zecom[2 + taille] = 0x00;

    put_gfx_Commande(zecom, 3 + taille);

    wait_gfx_ack();

    rep = get_gfx_char();

    rep = get_gfx_char();
}
//------------------------------------------------------------------------
void PicasoSerial::draw_string(string str, UINT16 x, UINT16 y,Font _font,
                               Color text_color,Color color_bckg)
{
    text_backround(color_bckg);

    text_foreground(text_color);

    text_setFont(_font);

    gfx_move_to(x, y);

    text_putstring(str);

}
//------------------------------------------------------------------------
void PicasoSerial::draw_diamond(UINT16 x1, UINT16 y1, UINT16 x2,UINT16 y2,
                                UINT16 x3,UINT16 y3,
                                UINT16 x4,UINT16 y4,Color color)
{
    unsigned char zecom [22] = "";
    UINT16 nb=0x0004;

    zecom[0] = (CMD_POLYGON >> 8)&0xFF;
    zecom[1] = (CMD_POLYGON & 0xFF);

    //n=4
    zecom[2]=(nb >> 8)&0xFF;
    zecom[3]=(nb & 0xFF);

    // coord X1[msb:Lsb]
    zecom[4] = (x1 >> 8)& 0xFF;
    zecom[5] = (x1) & 0xFF;

    // coord X2[msb:Lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2) & 0xFF;

    // coord X3[msb:lsb]
    zecom[8] = (x3 >> 8)& 0xFF;
    zecom[9] = (x3) & 0xFF;

    //// coord X4[msb:lsb]
    zecom[10] = (x4 >> 8)& 0xFF;
    zecom[11] = (x4) & 0xFF;

    // coord Y1[msb:lsb]
    zecom[12] = (y1 >> 8) & 0xFF;
    zecom[13] = (y1) & 0xFF;

    // coord Y2[msb:lsb]
    zecom[14] = (y2 >> 8) & 0xFF;
    zecom[15] = (y2) & 0xFF;

    // coord Y3[msb:lsb]
    zecom[16] = (y3 >> 8) & 0xFF;
    zecom[17] = (y3) & 0xFF;

    // coord Y4[msb:lsb]
    zecom[18] = (y4 >> 8) & 0xFF;
    zecom[19] = (y4) & 0xFF;

    // color
    zecom[20] = (color >> 8) & 0xFF;
    zecom[21] = color & 0xFF;

    put_gfx_Commande(zecom, 22);

    wait_gfx_ack();
}
//------------------------------------------------------------------------------
void PicasoSerial::draw_filled_diamond(UINT16 x1,UINT16 y1,UINT16 x2,UINT16 y2,
                                       UINT16 x3,UINT16 y3, UINT16 x4,UINT16 y4,Color color)
{
    unsigned char zecom [22] = "";
    UINT16 nb=0x0004;

    zecom[0] = (CMD_FILLED_POLYGON >> 8)&0xFF;
    zecom[1] = (CMD_FILLED_POLYGON & 0xFF);

    //n=4
    zecom[2]=(nb >> 8)&0xFF;
    zecom[3]=(nb & 0xFF);

    // coord X1[msb:Lsb]
    zecom[4] = (x1 >> 8)& 0xFF;
    zecom[5] = (x1) & 0xFF;

    // coord X2[msb:Lsb]
    zecom[6] = (x2 >> 8)& 0xFF;
    zecom[7] = (x2) & 0xFF;

    // coord X3[msb:lsb]
    zecom[8] = (x3 >> 8)& 0xFF;
    zecom[9] = (x3) & 0xFF;

    //// coord X4[msb:lsb]
    zecom[10] = (x4 >> 8)& 0xFF;
    zecom[11] = (x4) & 0xFF;

    // coord Y1[msb:lsb]
    zecom[12] = (y1 >> 8) & 0xFF;
    zecom[13] = (y1) & 0xFF;

    // coord Y2[msb:lsb]
    zecom[14] = (y2 >> 8) & 0xFF;
    zecom[15] = (y2) & 0xFF;

    // coord Y3[msb:lsb]
    zecom[16] = (y3 >> 8) & 0xFF;
    zecom[17] = (y3) & 0xFF;

    // coord Y4[msb:lsb]
    zecom[18] = (y4 >> 8) & 0xFF;
    zecom[19] = (y4) & 0xFF;

    // color
    zecom[20] = (color >> 8) & 0xFF;
    zecom[21] = color & 0xFF;

    put_gfx_Commande(zecom, 22);

    wait_gfx_ack();
}
//---------------------------------------------
void PicasoSerial::draw_ellipse(UINT16 xc, UINT16 yc, UINT16 xrad,
                                UINT16 yrad,Color color)
{
    unsigned char zecom [12] = "";

    zecom[0] = (CMD_ELLIPSE >> 8)&0xFF;
    zecom[1] = (CMD_ELLIPSE & 0xFF);

    // coord Xc[msb:Lsb]
    zecom[2] = (xc >> 8)& 0xFF;
    zecom[3] = (xc) & 0xFF;

    // coord Yc[msb:Lsb]
    zecom[4] = (yc >> 8)& 0xFF;
    zecom[5] = (yc) & 0xFF;

    // coord Xrad[msb:lsb]
    zecom[6] = (xrad >> 8)& 0xFF;
    zecom[7] = (xrad) & 0xFF;

    // coord Yrad[msb:lsb]
    zecom[8] = (yrad >> 8)& 0xFF;
    zecom[9] = (yrad) & 0xFF;

    // color
    zecom[10] = (color >> 8) & 0xFF;
    zecom[11] = color & 0xFF;

    put_gfx_Commande(zecom, 12);

    wait_gfx_ack();
}
//----------------------------------
void PicasoSerial::draw_filled_ellipse(UINT16 xc, UINT16 yc, UINT16 xrad,
                                       UINT16 yrad,Color color)
{
    unsigned char zecom [12] = "";

    zecom[0] = (CMD_FILLED_ELLIPSE >> 8)&0xFF;
    zecom[1] = (CMD_FILLED_ELLIPSE & 0xFF);

    // coord Xc[msb:Lsb]
    zecom[2] = (xc >> 8)& 0xFF;
    zecom[3] = (xc) & 0xFF;

    // coord Yc[msb:Lsb]
    zecom[4] = (yc >> 8)& 0xFF;
    zecom[5] = (yc) & 0xFF;

    // coord Xrad[msb:lsb]
    zecom[6] = (xrad >> 8)& 0xFF;
    zecom[7] = (xrad) & 0xFF;

    // coord Yrad[msb:lsb]
    zecom[8] = (yrad >> 8)& 0xFF;
    zecom[9] = (yrad) & 0xFF;

    // color
    zecom[10] = (color >> 8) & 0xFF;
    zecom[11] = color & 0xFF;

    put_gfx_Commande(zecom, 12);

    wait_gfx_ack();
}
//****************************************************************
// fin fichier
