#include "Label.h"

Label::Label(Screen* mScreen,UINT16 _x,UINT16 _y,string _text,Font _font,Color _colorText,Color _colorBkg):
    Widget(mScreen,0,_x,_y,10,10,_colorBkg)

{
    myText=_text;
    myFont=_font;
    myColorText=_colorText;

    myType=OBJ_LABEL;

    //
    UINT16 largeur=0;
    UINT16 hauteur=16;
    UINT16 taille=0;
    UINT16 incLargeur=12;

    switch(_font) {
            //
        case FONT_2:
            incLargeur=8;
            hauteur=8;
            largeur=8;
            break;

            //
        case FONT_3:
            incLargeur=8;
            hauteur=12;
            largeur=8;
            break;
            //
        case FONT_1:
            incLargeur=5;
            hauteur=7;
            largeur=5;
            break;

            //
        default:
            incLargeur=12;
            hauteur=16;
            largeur=8;
            break;
    }
    //cherche taille
    
    taille=_text.size();
    largeur=incLargeur*taille;
    
    if(largeur > incLargeur)
        largeur=largeur-incLargeur;

    myWidth=largeur;
    myHeight=hauteur;

    myScreen->addWidget((Widget*) this);
}
//-----------------------------------------------------
Label::~Label(void)
{
}
//-----------------------------------------------------
void Label::draw(void)
{
    // isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {

        ps->draw_string(myText,myX,myY,myFont,myColorText,myColor);
    }
    ps=0;
}
//------------------------------------------------------
void Label::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();
        
        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;

        this->draw();
    }
}
//-------------------------------------------------------
void Label::setNewText(string _newText)
{

    UINT16 hauteur=16;
    UINT16 incLargeur=12;
    UINT16 taille=0;

    switch(myFont) {
            //
        case FONT_2:
            incLargeur=8;
            hauteur=8;
            break;

            //
        case FONT_3:
            incLargeur=8;
            hauteur=12;
            break;
            //
        case FONT_1:
            incLargeur=5;
            hauteur=7;
            break;

            //
        default:
            incLargeur=12;
            hauteur=16;
            break;
    }
    
    taille=_newText.size();
    
    myWidth=taille*incLargeur;
    myHeight=hauteur;
    myText=_newText;

    setInvisible(true);
    setInvisible(false);
    
}